/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.exceptions.ParserException;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.AlpnExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CachedInfoExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CertificateStatusRequestExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CertificateStatusRequestV2ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.CertificateTypeExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ClientAuthzExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ClientCertificateTypeExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ClientCertificateUrlExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ECPointFormatExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EarlyDataExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EllipticCurvesExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EncryptThenMacExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EncryptedServerNameIndicationExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtendedMasterSecretExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtendedRandomExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.HRRKeyShareExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.HeartbeatExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.KeyShareExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.MaxFragmentLengthExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PSKKeyExchangeModesExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PWDClearExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PWDProtectExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PaddingExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PreSharedKeyExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.RenegotiationInfoExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SRPExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerAuthzExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerCertificateTypeExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ServerNameIndicationExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SessionTicketTLSExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SignatureAndHashAlgorithmsExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SignedCertificateTimestampExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SrtpExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.SupportedVersionsExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.TokenBindingExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.TruncatedHmacExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.TrustedCaIndicationExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.UnknownExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.UserMappingExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtensionParserFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ExtensionParser getExtensionParser(byte[] extensionBytes, int pointer, HandshakeMessageType handshakeMessageType, Config config) {
        if (extensionBytes.length - pointer < 2) {
            throw new ParserException("Could not retrieve Parser for ExtensionBytes. Not Enough bytes left for an ExtensionType");
        }
        byte[] typeBytes = new byte[]{extensionBytes[pointer], extensionBytes[pointer + 1]};
        ExtensionType type = ExtensionType.getExtensionType(typeBytes);
        ExtensionParser parser = null;
        switch (type) {
            case CLIENT_CERTIFICATE_URL: {
                parser = new ClientCertificateUrlExtensionParser(pointer, extensionBytes);
                break;
            }
            case EC_POINT_FORMATS: {
                parser = new ECPointFormatExtensionParser(pointer, extensionBytes);
                break;
            }
            case ELLIPTIC_CURVES: {
                parser = new EllipticCurvesExtensionParser(pointer, extensionBytes);
                break;
            }
            case ENCRYPTED_SERVER_NAME_INDICATION: {
                parser = new EncryptedServerNameIndicationExtensionParser(pointer, extensionBytes);
                break;
            }
            case HEARTBEAT: {
                parser = new HeartbeatExtensionParser(pointer, extensionBytes);
                break;
            }
            case MAX_FRAGMENT_LENGTH: {
                parser = new MaxFragmentLengthExtensionParser(pointer, extensionBytes);
                break;
            }
            case SERVER_NAME_INDICATION: {
                parser = new ServerNameIndicationExtensionParser(pointer, extensionBytes);
                break;
            }
            case SIGNATURE_AND_HASH_ALGORITHMS: {
                parser = new SignatureAndHashAlgorithmsExtensionParser(pointer, extensionBytes);
                break;
            }
            case SUPPORTED_VERSIONS: {
                parser = new SupportedVersionsExtensionParser(pointer, extensionBytes);
                break;
            }
            case EXTENDED_RANDOM: {
                if (config != null && config.isParseKeyShareOld().booleanValue()) break;
                parser = new ExtendedRandomExtensionParser(pointer, extensionBytes);
                break;
            }
            case KEY_SHARE_OLD: {
                if (config == null || !config.isParseKeyShareOld().booleanValue()) {
                    parser = new ExtendedRandomExtensionParser(pointer, extensionBytes);
                    break;
                }
            }
            case KEY_SHARE: {
                parser = ExtensionParserFactory.getKeyShareParser(extensionBytes, pointer, handshakeMessageType, type);
                break;
            }
            case STATUS_REQUEST: {
                parser = new CertificateStatusRequestExtensionParser(pointer, extensionBytes);
                break;
            }
            case TRUNCATED_HMAC: {
                parser = new TruncatedHmacExtensionParser(pointer, extensionBytes);
                break;
            }
            case TRUSTED_CA_KEYS: {
                parser = new TrustedCaIndicationExtensionParser(pointer, extensionBytes);
                break;
            }
            case ALPN: {
                parser = new AlpnExtensionParser(pointer, extensionBytes);
                break;
            }
            case CACHED_INFO: {
                parser = new CachedInfoExtensionParser(pointer, extensionBytes);
                break;
            }
            case CERT_TYPE: {
                parser = new CertificateTypeExtensionParser(pointer, extensionBytes);
                break;
            }
            case CLIENT_AUTHZ: {
                parser = new ClientAuthzExtensionParser(pointer, extensionBytes);
                break;
            }
            case CLIENT_CERTIFICATE_TYPE: {
                parser = new ClientCertificateTypeExtensionParser(pointer, extensionBytes);
                break;
            }
            case EARLY_DATA: {
                parser = new EarlyDataExtensionParser(pointer, extensionBytes);
                break;
            }
            case ENCRYPT_THEN_MAC: {
                parser = new EncryptThenMacExtensionParser(pointer, extensionBytes);
                break;
            }
            case EXTENDED_MASTER_SECRET: {
                parser = new ExtendedMasterSecretExtensionParser(pointer, extensionBytes);
                break;
            }
            case PADDING: {
                parser = new PaddingExtensionParser(pointer, extensionBytes);
                break;
            }
            case PRE_SHARED_KEY: {
                parser = new PreSharedKeyExtensionParser(pointer, extensionBytes);
                break;
            }
            case PSK_KEY_EXCHANGE_MODES: {
                parser = new PSKKeyExchangeModesExtensionParser(pointer, extensionBytes);
                break;
            }
            case RENEGOTIATION_INFO: {
                parser = new RenegotiationInfoExtensionParser(pointer, extensionBytes);
                break;
            }
            case SERVER_AUTHZ: {
                parser = new ServerAuthzExtensionParser(pointer, extensionBytes);
                break;
            }
            case SERVER_CERTIFICATE_TYPE: {
                parser = new ServerCertificateTypeExtensionParser(pointer, extensionBytes);
                break;
            }
            case SESSION_TICKET: {
                parser = new SessionTicketTLSExtensionParser(pointer, extensionBytes);
                break;
            }
            case SIGNED_CERTIFICATE_TIMESTAMP: {
                parser = new SignedCertificateTimestampExtensionParser(pointer, extensionBytes);
                break;
            }
            case SRP: {
                parser = new SRPExtensionParser(pointer, extensionBytes);
                break;
            }
            case STATUS_REQUEST_V2: {
                parser = new CertificateStatusRequestV2ExtensionParser(pointer, extensionBytes);
                break;
            }
            case TOKEN_BINDING: {
                parser = new TokenBindingExtensionParser(pointer, extensionBytes);
                break;
            }
            case USER_MAPPING: {
                parser = new UserMappingExtensionParser(pointer, extensionBytes);
                break;
            }
            case USE_SRTP: {
                parser = new SrtpExtensionParser(pointer, extensionBytes);
                break;
            }
            case PWD_PROTECT: {
                parser = new PWDProtectExtensionParser(pointer, extensionBytes);
                break;
            }
            case PWD_CLEAR: {
                parser = new PWDClearExtensionParser(pointer, extensionBytes);
                break;
            }
            case UNKNOWN: {
                parser = new UnknownExtensionParser(pointer, extensionBytes);
            }
        }
        if (parser == null) {
            LOGGER.debug("The ExtensionParser for the " + type.name() + " Extension is currently not implemented. Using the UnknownExtensionParser instead");
            parser = new UnknownExtensionParser(pointer, extensionBytes);
        }
        return parser;
    }

    private static ExtensionParser getKeyShareParser(byte[] extensionBytes, int pointer, HandshakeMessageType type, ExtensionType extensionType) {
        switch (type) {
            case HELLO_RETRY_REQUEST: {
                return new HRRKeyShareExtensionParser(pointer, extensionBytes);
            }
            case CLIENT_HELLO: 
            case SERVER_HELLO: {
                return new KeyShareExtensionParser(pointer, extensionBytes, extensionType);
            }
        }
        throw new UnsupportedOperationException("KeyShareExtension for following " + (Object)((Object)type) + " message NOT supported yet.");
    }

    private ExtensionParserFactory() {
    }
}

