/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CertificateStatusRequestExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateStatusRequestExtensionPreparator
extends ExtensionPreparator<CertificateStatusRequestExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CertificateStatusRequestExtensionMessage msg;

    public CertificateStatusRequestExtensionPreparator(Chooser chooser, CertificateStatusRequestExtensionMessage message, ExtensionSerializer<CertificateStatusRequestExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        this.msg.setCertificateStatusRequestType(this.chooser.getConfig().getCertificateStatusRequestExtensionRequestType().getCertificateStatusRequestValue());
        LOGGER.debug("Prepared the CertificateStatusRequestExtension with request type " + (Object)((Object)CertificateStatusRequestType.getCertificateStatusRequestType((Integer)this.msg.getCertificateStatusRequestType().getValue())));
        this.msg.setResponderIDList(this.chooser.getConfig().getCertificateStatusRequestExtensionResponderIDList());
        this.msg.setResponderIDListLength(((byte[])this.msg.getResponderIDList().getValue()).length);
        LOGGER.debug("Prepared the CertificateStatusRequestExtension with responder ID list " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getResponderIDList()));
        this.msg.setRequestExtension(this.chooser.getConfig().getCertificateStatusRequestExtensionRequestExtension());
        this.msg.setRequestExtensionLength(((byte[])this.msg.getRequestExtension().getValue()).length);
        LOGGER.debug("Prepared the CertificateStatusRequestExtension with request extension " + ArrayConverter.bytesToHexString((ModifiableByteArray)this.msg.getRequestExtension()));
    }
}

