/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.helper.LogAction;
import org.traccar.model.BaseModel;
import org.traccar.model.Group;
import org.traccar.model.Permission;
import org.traccar.model.User;
import org.traccar.session.ConnectionManager;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public abstract class BaseObjectResource<T extends BaseModel>
extends BaseResource {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ConnectionManager connectionManager;
    protected final Class<T> baseClass;

    public BaseObjectResource(Class<T> baseClass) {
        this.baseClass = baseClass;
    }

    @Path(value="{id}")
    @GET
    public Response getSingle(@PathParam(value="id") long id) throws StorageException {
        this.permissionsService.checkPermission(this.baseClass, this.getUserId(), id);
        BaseModel entity = (BaseModel)this.storage.getObject(this.baseClass, new Request((Columns)new Columns.All(), new Condition.Equals("id", id)));
        if (entity != null) {
            return Response.ok((Object)entity).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    public Response add(T entity) throws StorageException {
        this.permissionsService.checkEdit(this.getUserId(), (BaseModel)entity, true);
        ((BaseModel)entity).setId(this.storage.addObject(entity, new Request(new Columns.Exclude("id"))));
        LogAction.create(this.getUserId(), entity);
        this.storage.addPermission(new Permission(User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId()));
        this.cacheManager.invalidatePermission(true, User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId());
        this.connectionManager.invalidatePermission(true, User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId());
        LogAction.link(this.getUserId(), User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId());
        return Response.ok(entity).build();
    }

    @Path(value="{id}")
    @PUT
    public Response update(T entity) throws StorageException {
        User user;
        Group group;
        this.permissionsService.checkEdit(this.getUserId(), (BaseModel)entity, false);
        this.permissionsService.checkPermission(this.baseClass, this.getUserId(), ((BaseModel)entity).getId());
        if (entity instanceof User) {
            User before = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", ((BaseModel)entity).getId())));
            this.permissionsService.checkUserUpdate(this.getUserId(), before, (User)entity);
        } else if (entity instanceof Group && (group = (Group)entity).getId() == group.getGroupId()) {
            throw new IllegalArgumentException("Cycle in group hierarchy");
        }
        this.storage.updateObject(entity, new Request((Columns)new Columns.Exclude("id"), new Condition.Equals("id", ((BaseModel)entity).getId())));
        if (entity instanceof User && (user = (User)entity).getHashedPassword() != null) {
            this.storage.updateObject(entity, new Request((Columns)new Columns.Include("hashedPassword", "salt"), new Condition.Equals("id", ((BaseModel)entity).getId())));
        }
        this.cacheManager.updateOrInvalidate(true, entity);
        LogAction.edit(this.getUserId(), entity);
        return Response.ok(entity).build();
    }

    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws StorageException {
        this.permissionsService.checkEdit(this.getUserId(), this.baseClass, false);
        this.permissionsService.checkPermission(this.baseClass, this.getUserId(), id);
        this.storage.removeObject(this.baseClass, new Request(new Condition.Equals("id", id)));
        this.cacheManager.invalidate(this.baseClass, id);
        LogAction.remove(this.getUserId(), this.baseClass, id);
        return Response.noContent().build();
    }
}

