/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class BanGeocoder
extends JsonGeocoder {
    public BanGeocoder(Client client, int cacheSize, AddressFormat addressFormat) {
        super(client, "https://api-adresse.data.gouv.fr/reverse/?lat=%f&lon=%f", cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonArray result = json.getJsonArray("features");
        if (result != null && !result.isEmpty()) {
            JsonObject location = result.getJsonObject(0).getJsonObject("properties");
            Address address = new Address();
            address.setCountry("FR");
            if (location.containsKey((Object)"postcode")) {
                address.setPostcode(location.getString("postcode"));
            }
            if (location.containsKey((Object)"context")) {
                address.setDistrict(location.getString("context"));
            }
            if (location.containsKey((Object)"name")) {
                address.setStreet(location.getString("name"));
            }
            if (location.containsKey((Object)"city")) {
                address.setSettlement(location.getString("city"));
            }
            if (location.containsKey((Object)"housenumber")) {
                address.setHouse(location.getString("housenumber"));
            }
            if (location.containsKey((Object)"label")) {
                address.setFormattedAddress(location.getString("label"));
            }
            return address;
        }
        return null;
    }
}

