/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.traccar.config.Config;
import org.traccar.config.ConfigKey;
import org.traccar.config.Keys;
import org.traccar.database.StatisticsManager;
import org.traccar.mail.MailManager;
import org.traccar.model.User;
import org.traccar.notification.PropertiesProvider;

public final class SmtpMailManager
implements MailManager {
    private static final String CONTENT_TYPE = "text/html; charset=utf-8";
    private final Config config;
    private final StatisticsManager statisticsManager;

    public SmtpMailManager(Config config, StatisticsManager statisticsManager) {
        this.config = config;
        this.statisticsManager = statisticsManager;
    }

    private static void copyBooleanProperty(Properties properties, PropertiesProvider provider, ConfigKey<Boolean> key) {
        Boolean value = provider.getBoolean(key);
        if (value != null) {
            properties.put(key.getKey(), String.valueOf(value));
        }
    }

    private static void copyStringProperty(Properties properties, PropertiesProvider provider, ConfigKey<String> key) {
        String value = provider.getString(key);
        if (value != null) {
            properties.put(key.getKey(), value);
        }
    }

    private static Properties getProperties(PropertiesProvider provider) {
        String host = provider.getString(Keys.MAIL_SMTP_HOST);
        if (host != null) {
            Properties properties = new Properties();
            properties.put(Keys.MAIL_TRANSPORT_PROTOCOL.getKey(), provider.getString(Keys.MAIL_TRANSPORT_PROTOCOL));
            properties.put(Keys.MAIL_SMTP_HOST.getKey(), host);
            properties.put(Keys.MAIL_SMTP_PORT.getKey(), String.valueOf(provider.getInteger(Keys.MAIL_SMTP_PORT)));
            SmtpMailManager.copyBooleanProperty(properties, provider, Keys.MAIL_SMTP_STARTTLS_ENABLE);
            SmtpMailManager.copyBooleanProperty(properties, provider, Keys.MAIL_SMTP_STARTTLS_REQUIRED);
            SmtpMailManager.copyBooleanProperty(properties, provider, Keys.MAIL_SMTP_SSL_ENABLE);
            SmtpMailManager.copyStringProperty(properties, provider, Keys.MAIL_SMTP_SSL_TRUST);
            SmtpMailManager.copyStringProperty(properties, provider, Keys.MAIL_SMTP_SSL_PROTOCOLS);
            SmtpMailManager.copyStringProperty(properties, provider, Keys.MAIL_SMTP_USERNAME);
            SmtpMailManager.copyStringProperty(properties, provider, Keys.MAIL_SMTP_PASSWORD);
            SmtpMailManager.copyStringProperty(properties, provider, Keys.MAIL_SMTP_FROM);
            SmtpMailManager.copyStringProperty(properties, provider, Keys.MAIL_SMTP_FROM_NAME);
            return properties;
        }
        return null;
    }

    @Override
    public boolean getEmailEnabled() {
        return this.config.hasKey(Keys.MAIL_SMTP_HOST);
    }

    @Override
    public void sendMessage(User user, String subject, String body) throws MessagingException {
        this.sendMessage(user, subject, body, null);
    }

    @Override
    public void sendMessage(User user, String subject, String body, MimeBodyPart attachment) throws MessagingException {
        Properties properties = null;
        if (!this.config.getBoolean(Keys.MAIL_SMTP_IGNORE_USER_CONFIG)) {
            properties = SmtpMailManager.getProperties(new PropertiesProvider(user));
        }
        if (properties == null) {
            properties = SmtpMailManager.getProperties(new PropertiesProvider(this.config));
        }
        if (properties == null) {
            throw new MessagingException("No SMTP configuration found");
        }
        Session session = Session.getInstance((Properties)properties);
        MimeMessage message = new MimeMessage(session);
        String from = properties.getProperty(Keys.MAIL_SMTP_FROM.getKey());
        if (from != null) {
            String fromName = properties.getProperty(Keys.MAIL_SMTP_FROM_NAME.getKey());
            if (fromName != null) {
                try {
                    message.setFrom((Address)new InternetAddress(from, fromName));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException("Email address issue");
                }
            } else {
                message.setFrom((Address)new InternetAddress(from));
            }
        }
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(user.getEmail()));
        message.setSubject(subject);
        message.setSentDate(new Date());
        if (attachment != null) {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)body, CONTENT_TYPE);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            multipart.addBodyPart((BodyPart)attachment);
            message.setContent((Multipart)multipart);
        } else {
            message.setContent((Object)body, CONTENT_TYPE);
        }
        try (Transport transport = session.getTransport();){
            this.statisticsManager.registerMail();
            transport.connect(properties.getProperty(Keys.MAIL_SMTP_HOST.getKey()), properties.getProperty(Keys.MAIL_SMTP_USERNAME.getKey()), properties.getProperty(Keys.MAIL_SMTP_PASSWORD.getKey()));
            transport.sendMessage((Message)message, message.getAllRecipients());
        }
    }
}

