/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class HuaShengProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_POSITION = 43520;
    public static final int MSG_POSITION_RSP = 65281;
    public static final int MSG_LOGIN = 43522;
    public static final int MSG_LOGIN_RSP = 65283;
    public static final int MSG_UPFAULT = 43538;
    public static final int MSG_UPFAULT_RSP = 65299;
    public static final int MSG_HSO_REQ = 2;
    public static final int MSG_HSO_RSP = 3;

    public HuaShengProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int type, int index, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(192);
            response.writeShort(256);
            response.writeShort(12 + (content != null ? content.readableBytes() : 0));
            response.writeShort(type);
            response.writeShort(0);
            response.writeInt(index);
            if (content != null) {
                response.writeBytes(content);
                content.release();
            }
            response.writeByte(192);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private String decodeAlarm(int event) {
        switch (event) {
            case 4: {
                return "fatigueDriving";
            }
            case 6: {
                return "sos";
            }
            case 7: {
                return "hardBraking";
            }
            case 8: {
                return "hardAcceleration";
            }
            case 9: {
                return "hardCornering";
            }
            case 10: {
                return "accident";
            }
            case 16: {
                return "removing";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(1);
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        int type = buf.readUnsignedShort();
        buf.readUnsignedShort();
        int index = buf.readInt();
        if (type == 43522) {
            while (buf.readableBytes() > 4) {
                int subtype = buf.readUnsignedShort();
                int length = buf.readUnsignedShort() - 4;
                if (subtype == 3) {
                    String imei = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString();
                    DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
                    if (deviceSession == null || channel == null) continue;
                    ByteBuf content = Unpooled.buffer();
                    content.writeByte(0);
                    this.sendResponse(channel, 65283, index, content);
                    continue;
                }
                buf.skipBytes(length);
            }
        } else if (type == 2) {
            this.sendResponse(channel, 3, index, null);
        } else {
            if (type == 43538) {
                return this.decodeFaultCodes(channel, remoteAddress, buf);
            }
            if (type == 43520) {
                return this.decodePosition(channel, remoteAddress, buf, index);
            }
        }
        return null;
    }

    private Position decodeFaultCodes(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        StringBuilder codes = new StringBuilder();
        while (buf.readableBytes() > 2) {
            char prefix;
            String value = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(2));
            int digit = Integer.parseInt(value.substring(0, 1), 16);
            switch (digit >> 2) {
                default: {
                    prefix = 'P';
                    break;
                }
                case 1: {
                    prefix = 'C';
                    break;
                }
                case 2: {
                    prefix = 'B';
                    break;
                }
                case 3: {
                    prefix = 'U';
                }
            }
            codes.append(prefix).append(digit % 4).append(value.substring(1));
            if (buf.readableBytes() <= 2) continue;
            codes.append(' ');
        }
        position.set("dtcs", codes.toString());
        return position;
    }

    private Position decodePosition(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int index) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int status = buf.readUnsignedShort();
        position.setValid(BitUtil.check(status, 15));
        position.set("status", status);
        position.set("ignition", BitUtil.check(status, 14));
        int event = buf.readUnsignedShort();
        position.set("alarm", this.decodeAlarm(event));
        position.set("event", event);
        String time = buf.readCharSequence(12, StandardCharsets.US_ASCII).toString();
        DateBuilder dateBuilder = new DateBuilder().setYear(Integer.parseInt(time.substring(0, 2))).setMonth(Integer.parseInt(time.substring(2, 4))).setDay(Integer.parseInt(time.substring(4, 6))).setHour(Integer.parseInt(time.substring(6, 8))).setMinute(Integer.parseInt(time.substring(8, 10))).setSecond(Integer.parseInt(time.substring(10, 12)));
        position.setTime(dateBuilder.getDate());
        position.setLongitude((double)buf.readInt() * 1.0E-5);
        position.setLatitude((double)buf.readInt() * 1.0E-5);
        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
        position.setCourse(buf.readUnsignedShort());
        position.setAltitude(buf.readUnsignedShort());
        position.set("odometer", buf.readUnsignedShort() * 1000);
        Network network = new Network();
        block9: while (buf.readableBytes() > 4) {
            int subtype = buf.readUnsignedShort();
            int length = buf.readUnsignedShort() - 4;
            switch (subtype) {
                case 1: {
                    int rpm;
                    int coolantTemperature = buf.readUnsignedByte() - 40;
                    if (coolantTemperature <= 215) {
                        position.set("coolantTemp", coolantTemperature);
                    }
                    if ((rpm = buf.readUnsignedShort()) <= 65535) {
                        position.set("rpm", rpm);
                    }
                    position.set("averageSpeed", buf.readUnsignedByte());
                    buf.readUnsignedShort();
                    position.set("fuelConsumption", (double)buf.readUnsignedShort() * 0.01);
                    position.set("tripOdometer", buf.readUnsignedShort());
                    position.set("power", (double)buf.readUnsignedShort() * 0.01);
                    position.set("fuel", (double)buf.readUnsignedByte() * 0.4);
                    buf.readUnsignedInt();
                    break;
                }
                case 5: {
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("hdop", buf.readUnsignedByte());
                    buf.readUnsignedInt();
                    break;
                }
                case 9: {
                    position.set("vin", buf.readCharSequence(length, StandardCharsets.US_ASCII).toString());
                    break;
                }
                case 17: {
                    position.set("hours", (double)buf.readUnsignedInt() * 0.05);
                    break;
                }
                case 20: {
                    position.set("engineLoad", (double)buf.readUnsignedByte() / 255.0);
                    position.set("timingAdvance", (double)buf.readUnsignedByte() * 0.5);
                    position.set("airTemp", buf.readUnsignedByte() - 40);
                    position.set("airFlow", (double)buf.readUnsignedShort() * 0.01);
                    position.set("throttle", (double)buf.readUnsignedByte() / 255.0);
                    break;
                }
                case 32: {
                    String[] cells;
                    for (String cell : cells = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString().split("\\+")) {
                        String[] values = cell.split("@");
                        network.addCellTower(CellTower.from(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2], 16), Integer.parseInt(values[3], 16)));
                    }
                    continue block9;
                }
                case 33: {
                    String[] points;
                    for (String point : points = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString().split("\\+")) {
                        String[] values = point.split("@");
                        network.addWifiAccessPoint(WifiAccessPoint.from(values[0], Integer.parseInt(values[1])));
                    }
                    continue block9;
                }
                default: {
                    buf.skipBytes(length);
                }
            }
        }
        if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
            position.setNetwork(network);
        }
        this.sendResponse(channel, 65281, index, null);
        return position;
    }
}

