/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.convert;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.servicelocator.LiquibaseService;

@LiquibaseService(skip=true)
public class ConvertCommandStep
extends AbstractCommandStep {
    public static final CommandArgumentDefinition<String> SRC_ARG;
    public static final CommandArgumentDefinition<String> OUT_ARG;
    public static final CommandArgumentDefinition<String> CLASSPATH_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{{"convert"}};
    }

    @Override
    public int getOrder(CommandDefinition commandDefinition) {
        return -1;
    }

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String src = commandScope.getArgumentValue(SRC_ARG);
        String out = commandScope.getArgumentValue(OUT_ARG);
        String classpath = commandScope.getArgumentValue(CLASSPATH_ARG);
        ArrayList<ResourceAccessor> openers = new ArrayList<ResourceAccessor>();
        openers.add(new DirectoryResourceAccessor(new File(".")));
        openers.add(new ClassLoaderResourceAccessor());
        if (classpath != null) {
            openers.add(new DirectoryResourceAccessor(new File(classpath)));
        }
        CompositeResourceAccessor resourceAccessor = new CompositeResourceAccessor(openers);
        ChangeLogParser sourceParser = ChangeLogParserFactory.getInstance().getParser(src, resourceAccessor);
        ChangeLogSerializer outSerializer = ChangeLogSerializerFactory.getInstance().getSerializer(out);
        DatabaseChangeLog changeLog = sourceParser.parse(src, new ChangeLogParameters(), resourceAccessor);
        File outFile = new File(out);
        if (!outFile.exists()) {
            outFile.getParentFile().mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(outFile);){
            outSerializer.write(changeLog.getChangeSets(), outputStream);
        }
        Scope.getCurrentScope().getUI().sendMessage("Converted successfully");
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{{"convert"}});
        SRC_ARG = builder.argument("src", String.class).required().build();
        OUT_ARG = builder.argument("out", String.class).required().build();
        CLASSPATH_ARG = builder.argument("classpath", String.class).required().build();
    }
}

