"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

var _constants = require("../../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    indexService
  } = services;
  router.post({
    path: _constants.NODE_API._SEARCH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.search);
  router.get({
    path: _constants.NODE_API._INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean(),
        expandWildcards: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, indexService.getIndices);
  router.post({
    path: _constants.NODE_API.APPLY_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.applyPolicy);
  router.post({
    path: _constants.NODE_API.EDIT_ROLLOVER_ALIAS,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.editRolloverAlias);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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