"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class IndexService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "apiCaller", async (context, request, response) => {
      const useQuery = !request.body;
      const usedParam = useQuery ? request.query : request.body;
      const {
        endpoint,
        data,
        hideLog
      } = usedParam || {};

      try {
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const payload = useQuery ? JSON.parse(data || "{}") : data;
        const commonCallerResponse = await callWithRequest(endpoint, payload || {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: commonCallerResponse
          }
        });
      } catch (err) {
        if (!hideLog) {
          console.error("Index Management - CommonService - apiCaller", err);
        }

        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err === null || err === void 0 ? void 0 : err.message,
            body: (err === null || err === void 0 ? void 0 : err.body) || ""
          }
        });
      }
    });

    this.osDriver = osDriver;
  }

}

exports.default = IndexService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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