"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceConnectionValidator = void 0;

var _error = require("../lib/error");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class DataSourceConnectionValidator {
  constructor(callDataCluster) {
    this.callDataCluster = callDataCluster;
  }

  async validate() {
    try {
      return await this.callDataCluster.info();
    } catch (e) {
      throw (0, _error.createDataSourceError)(e);
    }
  }

}

exports.DataSourceConnectionValidator = DataSourceConnectionValidator;