/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.access;

import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.util.Environment;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;

public class ErrorLogger {
    public static boolean disabled = Environment.getStandAlone();
    private static HashSet<String> loggedErrors = new HashSet();

    public static void log(final Exception exception) {
        if (disabled) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Session session = SessionFactory.getInstance().getSession(false);
                if (session != null) {
                    session.logException(exception);
                }
            }
        }.start();
    }

    public static void log(String string, Exception exception) {
        String string2 = string + "\n" + ErrorLogger.getStackTrace(exception);
        ErrorLogger.log(string2);
    }

    public static void log(final String string) {
        System.out.println(string);
        if (disabled) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Session session = SessionFactory.getInstance().getSession(false);
                if (session != null) {
                    session.logString(string);
                }
            }
        }.start();
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            try {
                throw new Exception("Simulated Exception");
            }
            catch (Exception exception) {
                throwable = exception;
            }
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return ((Object)stringWriter).toString();
    }

    public static synchronized void logOnce(String string, String string2, Exception exception) {
        if (loggedErrors.contains(string)) {
            return;
        }
        loggedErrors.add(string);
        ErrorLogger.log(string2, exception);
    }
}

