# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401


class ScriptCreateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'script': 'str',
        'language': 'ScriptLanguage'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'script': 'script',
        'language': 'language'
    }

    def __init__(self, name=None, description=None, script=None, language=None):  # noqa: E501,D401,D403
        """ScriptCreateRequest - a model defined in OpenAPI."""  # noqa: E501
        self._name = None
        self._description = None
        self._script = None
        self._language = None
        self.discriminator = None

        self.name = name
        self.description = description
        self.script = script
        self.language = language

    @property
    def name(self):
        """Get the name of this ScriptCreateRequest.

        The name of the script. The name must be unique within the organization.

        :return: The name of this ScriptCreateRequest.
        :rtype: str
        """  # noqa: E501
        return self._name

    @name.setter
    def name(self, name):
        """Set the name of this ScriptCreateRequest.

        The name of the script. The name must be unique within the organization.

        :param name: The name of this ScriptCreateRequest.
        :type: str
        """  # noqa: E501
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        self._name = name

    @property
    def description(self):
        """Get the description of this ScriptCreateRequest.

        :return: The description of this ScriptCreateRequest.
        :rtype: str
        """  # noqa: E501
        return self._description

    @description.setter
    def description(self, description):
        """Set the description of this ScriptCreateRequest.

        :param description: The description of this ScriptCreateRequest.
        :type: str
        """  # noqa: E501
        if description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501
        self._description = description

    @property
    def script(self):
        """Get the script of this ScriptCreateRequest.

        The script to execute.

        :return: The script of this ScriptCreateRequest.
        :rtype: str
        """  # noqa: E501
        return self._script

    @script.setter
    def script(self, script):
        """Set the script of this ScriptCreateRequest.

        The script to execute.

        :param script: The script of this ScriptCreateRequest.
        :type: str
        """  # noqa: E501
        if script is None:
            raise ValueError("Invalid value for `script`, must not be `None`")  # noqa: E501
        self._script = script

    @property
    def language(self):
        """Get the language of this ScriptCreateRequest.

        :return: The language of this ScriptCreateRequest.
        :rtype: ScriptLanguage
        """  # noqa: E501
        return self._language

    @language.setter
    def language(self, language):
        """Set the language of this ScriptCreateRequest.

        :param language: The language of this ScriptCreateRequest.
        :type: ScriptLanguage
        """  # noqa: E501
        if language is None:
            raise ValueError("Invalid value for `language`, must not be `None`")  # noqa: E501
        self._language = language

    def to_dict(self):
        """Return the model properties as a dict."""
        result = {}

        for attr, _ in self.openapi_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Return the string representation of the model."""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`."""
        return self.to_str()

    def __eq__(self, other):
        """Return true if both objects are equal."""
        if not isinstance(other, ScriptCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Return true if both objects are not equal."""
        return not self == other
