/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import org.apache.solr.analytics.AnalyticsDriver;
import org.apache.solr.analytics.AnalyticsRequestManager;
import org.apache.solr.analytics.AnalyticsRequestParser;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.stream.AnalyticsShardRequestManager;
import org.apache.solr.analytics.util.OldAnalyticsRequestConverter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;

public class AnalyticsComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "analytics";

    public void init(NamedList<?> args) {
        AnalyticsRequestParser.init();
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        String analyticsRequest = rb.req.getParams().get(COMPONENT_NAME);
        rb.setOlapAnalytics(false);
        rb.setAnalytics(false);
        boolean isDistributed = rb.isDistributed();
        if (analyticsRequest != null) {
            rb.setAnalytics(true);
            rb.setAnalyticsRequestManager((Object)AnalyticsRequestParser.parse(analyticsRequest, new ExpressionFactory(rb.req.getSchema()), isDistributed));
        } else if (rb.req.getParams().getBool("olap", false)) {
            rb.setAnalyticsRequestManager((Object)AnalyticsRequestParser.parse(OldAnalyticsRequestConverter.convert(rb.req.getParams()), new ExpressionFactory(rb.req.getSchema()), isDistributed));
            rb.setOlapAnalytics(true);
            rb.setAnalytics(true);
        }
        if (rb.isAnalytics()) {
            AnalyticsRequestManager reqManager = this.getAnalyticsRequestManager(rb);
            if (isDistributed) {
                reqManager.sendShards = true;
                reqManager.shardStream = new AnalyticsShardRequestManager(rb.req.getParams(), reqManager);
            } else {
                reqManager.sendShards = false;
                rb.setNeedDocSet(true);
            }
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        if (!rb.isAnalytics()) {
            return;
        }
        AnalyticsRequestManager reqManager = this.getAnalyticsRequestManager(rb);
        AnalyticsDriver.drive(reqManager, rb.req.getSearcher(), rb.getResults().docSet, rb.req);
        if (rb.isOlapAnalytics()) {
            rb.rsp.add("stats", reqManager.createOldResponse());
        } else {
            rb.rsp.add("analytics_response", reqManager.createResponse());
        }
        rb.setAnalytics(false);
        rb.setOlapAnalytics(false);
    }

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.isAnalytics() || rb.stage != ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_DONE;
        }
        AnalyticsRequestManager reqManager = this.getAnalyticsRequestManager(rb);
        if (!reqManager.sendShards) {
            return ResponseBuilder.STAGE_DONE;
        }
        reqManager.shardStream.sendRequests(rb.req.getCore().getCoreDescriptor().getCollectionName(), rb.req.getCoreContainer().getZkController().getZkServerAddress());
        reqManager.sendShards = false;
        return ResponseBuilder.STAGE_DONE;
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        sreq.params.remove(COMPONENT_NAME);
        sreq.params.remove("olap");
        super.modifyRequest(rb, who, sreq);
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        super.handleResponses(rb, sreq);
    }

    public void finishStage(ResponseBuilder rb) {
        if (rb.isAnalytics() && rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            AnalyticsRequestManager reqManager = this.getAnalyticsRequestManager(rb);
            if (rb.isOlapAnalytics()) {
                rb.rsp.add("stats", reqManager.createOldResponse());
            } else {
                rb.rsp.add("analytics_response", reqManager.createResponse());
            }
            if (reqManager.isPartialResults()) {
                rb.rsp.getResponseHeader().asShallowMap().put("partialResults", true);
            }
        }
        super.finishStage(rb);
    }

    public String getName() {
        return COMPONENT_NAME;
    }

    public String getDescription() {
        return "Perform analytics";
    }

    private AnalyticsRequestManager getAnalyticsRequestManager(ResponseBuilder rb) {
        return (AnalyticsRequestManager)rb.getAnalyticsRequestManager();
    }
}

