/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.carrot2.attrs.AttrComposite;
import org.carrot2.attrs.AttrStringArray;
import org.carrot2.language.GlobDictionary;
import org.carrot2.language.LabelFilter;
import org.carrot2.language.LabelFilterDictionary;
import org.carrot2.language.StopwordFilter;
import org.carrot2.language.StopwordFilterDictionary;

public class DefaultDictionaryImpl
extends AttrComposite
implements StopwordFilterDictionary,
LabelFilterDictionary {
    public AttrStringArray exact;
    public AttrStringArray glob;
    public AttrStringArray regexp;

    public DefaultDictionaryImpl() {
        this.exact = this.attributes.register("exact", AttrStringArray.builder().label("Exact strings to filter out.").defaultValue(new String[0]));
        this.glob = this.attributes.register("glob", AttrStringArray.builder().label("Globbed expressions to filter out.").defaultValue(new String[0]));
        this.regexp = this.attributes.register("regexp", AttrStringArray.builder().label("Regular expression patterns.").defaultValue(new String[0]));
    }

    @Override
    public StopwordFilter compileStopwordFilter() {
        Predicate<String> compiled = this.compile();
        return t -> !compiled.test(t.toString());
    }

    @Override
    public LabelFilter compileLabelFilter() {
        Predicate<String> compiled = this.compile();
        return t -> !compiled.test(t.toString());
    }

    private Predicate<String> compile() {
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        if (!this.exact.isEmpty()) {
            predicates.add(this.toSet((String[])this.exact.get())::contains);
        }
        if (!this.glob.isEmpty()) {
            GlobDictionary glob = GlobDictionary.compilePatterns(this.toSet((String[])this.glob.get()).stream());
            predicates.add(glob::test);
        }
        if (!this.regexp.isEmpty()) {
            Pattern compiled = DefaultDictionaryImpl.union(DefaultDictionaryImpl.compile(this.toSet((String[])this.regexp.get())));
            predicates.add(label -> compiled.matcher((CharSequence)label).find());
        }
        if (predicates.isEmpty()) {
            return v -> false;
        }
        Iterator it = predicates.iterator();
        Predicate p = (Predicate)it.next();
        while (it.hasNext()) {
            p = p.or((Predicate)it.next());
        }
        return p;
    }

    private Set<String> toSet(String[] strings) {
        return new LinkedHashSet<String>(Arrays.asList(strings));
    }

    private static List<Pattern> compile(Collection<String> patterns) {
        ArrayList<Pattern> compiled = new ArrayList<Pattern>();
        for (String p : patterns) {
            compiled.add(Pattern.compile(p));
        }
        return compiled;
    }

    private static Pattern union(List<Pattern> patterns) {
        StringBuilder union = new StringBuilder();
        union.append("(");
        for (int i = 0; i < patterns.size(); ++i) {
            if (i > 0) {
                union.append(")|(");
            }
            union.append(patterns.get(i).toString());
        }
        union.append(")");
        return Pattern.compile(union.toString());
    }
}

