/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.solr.search.facet.SingletonDISI;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SweepCountAware;
import org.apache.solr.search.facet.UnionDISI;

abstract class SweepDISI
extends DocIdSetIterator
implements SweepCountAware {
    public final int size;
    final SlotAcc.CountSlotAcc[] countAccs;

    public SweepDISI(int size, SlotAcc.CountSlotAcc[] countAccs) {
        this.size = size;
        this.countAccs = countAccs;
    }

    private static boolean addAcc(SlotAcc.SweepCountAccStruct entry, DocIdSetIterator[] subIterators, SlotAcc.CountSlotAcc[] activeCountAccs, LeafReaderContext subCtx, int idx) throws IOException {
        subIterators[idx] = entry.docSet.iterator(subCtx);
        if (subIterators[idx] == null) {
            return false;
        }
        activeCountAccs[idx] = entry.countAcc;
        return true;
    }

    static SweepDISI newInstance(SlotAcc.SweepCountAccStruct base, List<SlotAcc.SweepCountAccStruct> others, DocIdSetIterator[] subIterators, SlotAcc.CountSlotAcc[] activeCountAccs, LeafReaderContext subCtx) throws IOException {
        int activeCt = 0;
        int baseIdx = base == null || !SweepDISI.addAcc(base, subIterators, activeCountAccs, subCtx, activeCt) ? -1 : activeCt++;
        for (SlotAcc.SweepCountAccStruct entry : others) {
            if (!SweepDISI.addAcc(entry, subIterators, activeCountAccs, subCtx, activeCt)) continue;
            ++activeCt;
        }
        switch (activeCt) {
            case 0: {
                return null;
            }
            case 1: {
                return new SingletonDISI(subIterators[0], activeCountAccs, baseIdx >= 0);
            }
        }
        return new UnionDISI(subIterators, activeCountAccs, activeCt, baseIdx);
    }

    public int docID() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long cost() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

