/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class FeatureContainer {
    public static final String ROOT = "###ROOT";
    private final Map<String, List<ConfigInfo>> finalConfigs = new HashMap<String, List<ConfigInfo>>();
    private final Map<String, Group> packagesRoots = new HashMap<String, Group>();
    private final Map<String, Group> featuresSpecRoots = new HashMap<String, Group>();
    private Map<String, FeatureContainer> fullDependencies = new HashMap<String, FeatureContainer>();
    private final String name;
    private final FeaturePackLocation.FPID fpid;
    private boolean edit;
    private Map<ResolvedSpecId, FeatureSpecInfo> allSpecs;
    private Map<Identity, Group> allPackages;
    private Map<ResolvedSpecId, List<FeatureInfo>> allFeatures;
    private final ProvisioningConfig config;
    private final Set<ConfigId> layers = new HashSet<ConfigId>();
    private final Set<String> optionalPackagesProducers = new TreeSet<String>();
    private final Map<String, Map<String, Set<String>>> optionalPackages = new TreeMap<String, Map<String, Set<String>>>();
    private final Map<String, Map<String, Set<String>>> passivePackages = new TreeMap<String, Map<String, Set<String>>>();
    private final Map<String, Set<String>> orphanOptionalPackages = new TreeMap<String, Set<String>>();
    private final Map<String, Set<String>> orphanPassivePackages = new TreeMap<String, Set<String>>();

    protected FeatureContainer(String name, FeaturePackLocation.FPID fpid, ProvisioningConfig config) {
        this.name = name;
        this.fpid = fpid;
        this.config = config;
    }

    public ProvisioningConfig getProvisioningConfig() {
        return this.config;
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public String getName() {
        return this.name;
    }

    public void setFullDependencies(Map<String, FeatureContainer> fullDependencies) {
        this.fullDependencies = Collections.unmodifiableMap(fullDependencies);
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public Map<String, FeatureContainer> getFullDependencies() {
        return this.fullDependencies;
    }

    protected void addFinalConfig(ConfigInfo info) {
        List<ConfigInfo> lst = this.finalConfigs.get(info.getModel());
        if (lst == null) {
            lst = new ArrayList<ConfigInfo>();
            this.finalConfigs.put(info.getModel(), lst);
        }
        lst.add(info);
    }

    public Map<String, List<ConfigInfo>> getFinalConfigs() {
        return Collections.unmodifiableMap(this.finalConfigs);
    }

    protected void setFeatureSpecRoot(String origin, Group featuresSpecRoot) {
        this.featuresSpecRoots.put(origin, featuresSpecRoot);
    }

    protected void setPackagesRoot(String origin, Group packagesRoot) {
        this.packagesRoots.put(origin, packagesRoot);
    }

    public Map<String, Group> getFeatureSpecs() {
        return this.featuresSpecRoots;
    }

    public Map<String, Group> getPackages() {
        return this.packagesRoots;
    }

    public Map<ResolvedSpecId, FeatureSpecInfo> getAllSpecs() {
        return Collections.unmodifiableMap(this.allSpecs);
    }

    void seAllFeatureSpecs(Map<ResolvedSpecId, FeatureSpecInfo> allSpecs) {
        this.allSpecs = allSpecs;
    }

    public Map<Identity, Group> getAllPackages() {
        return Collections.unmodifiableMap(this.allPackages);
    }

    void setAllPackages(Map<Identity, Group> allPackages) {
        this.allPackages = allPackages;
    }

    public Map<ResolvedSpecId, List<FeatureInfo>> getAllFeatures() {
        return Collections.unmodifiableMap(this.allFeatures);
    }

    void setAllFeatures(Map<ResolvedSpecId, List<FeatureInfo>> allFeatures) {
        this.allFeatures = allFeatures;
    }

    void addLayers(Set<ConfigId> layers) {
        this.layers.addAll(layers);
    }

    public Set<ConfigId> getLayers() {
        return this.layers;
    }

    void addOptionalPackage(String producer, String spec, String pkg) {
        Set<String> set;
        Map<String, Set<String>> map = this.optionalPackages.get(producer);
        if (map == null) {
            this.optionalPackagesProducers.add(producer);
            map = new TreeMap<String, Set<String>>();
            this.optionalPackages.put(producer, map);
        }
        if ((set = map.get(spec)) == null) {
            set = new TreeSet<String>();
            map.put(spec, set);
        }
        set.add(pkg);
    }

    void addPassivePackage(String producer, String spec, String pkg) {
        Set<String> set;
        Map<String, Set<String>> map = this.passivePackages.get(producer);
        if (map == null) {
            this.optionalPackagesProducers.add(producer);
            map = new TreeMap<String, Set<String>>();
            this.passivePackages.put(producer, map);
        }
        if ((set = map.get(spec)) == null) {
            set = new TreeSet<String>();
            map.put(spec, set);
        }
        set.add(pkg);
    }

    void addOrphanOptionalPackage(String producer, String pkg) {
        Set<String> set = this.orphanOptionalPackages.get(producer);
        if (set == null) {
            this.optionalPackagesProducers.add(producer);
            set = new TreeSet<String>();
            this.orphanOptionalPackages.put(producer, set);
        }
        set.add(pkg);
    }

    void addOrphanPassivePackage(String producer, String pkg) {
        Set<String> set = this.orphanPassivePackages.get(producer);
        if (set == null) {
            this.optionalPackagesProducers.add(producer);
            set = new TreeSet<String>();
            this.orphanPassivePackages.put(producer, set);
        }
        set.add(pkg);
    }

    public Set<String> getOptionalPackagesProducers() {
        return Collections.unmodifiableSet(this.optionalPackagesProducers);
    }

    public Map<String, Map<String, Set<String>>> getOptionalPackages() {
        return Collections.unmodifiableMap(this.optionalPackages);
    }

    public Map<String, Map<String, Set<String>>> getPassivePackages() {
        return Collections.unmodifiableMap(this.passivePackages);
    }

    public Map<String, Set<String>> getOrphanOptionalPackages() {
        return Collections.unmodifiableMap(this.orphanOptionalPackages);
    }

    public Map<String, Set<String>> getOrphanPassivePackages() {
        return Collections.unmodifiableMap(this.orphanPassivePackages);
    }
}

