/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.MavenUniverseInstaller;
import org.jboss.galleon.universe.maven.repo.SimplisticMavenRepoManager;

@Mojo(name="create-universe")
public class CreateUniverseMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(required=true, defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(required=true, defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(required=true, defaultValue="${project.version}")
    private String version;
    @Parameter(required=true)
    private List<ProducerSpec> producers = Collections.emptyList();
    @Parameter(defaultValue="false", property="galleon.skip")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info("Skipping the create-universe goal.");
            return;
        }
        MavenArtifact universeArtifact = new MavenArtifact().setGroupId(this.groupId).setArtifactId(this.artifactId).setVersion(this.version);
        MavenUniverseInstaller installer = new MavenUniverseInstaller(SimplisticMavenRepoManager.getInstance(Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("local-repo"), new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories)), universeArtifact);
        HashSet<String> names = new HashSet<String>(this.producers.size());
        for (ProducerSpec producer : this.producers) {
            if (!names.add(producer.name)) {
                throw new MojoExecutionException("Duplicate producer " + producer.name);
            }
            try {
                installer.addProducer(producer.name, producer.groupId, producer.artifactId, producer.versionRange);
            }
            catch (MavenUniverseException e) {
                throw new MojoExecutionException("Failed to add producer " + producer.name, e);
            }
        }
        try {
            installer.install();
        }
        catch (MavenUniverseException e) {
            throw new MojoExecutionException("Failed to create universe", e);
        }
        this.projectHelper.attachArtifact(this.project, "jar", universeArtifact.getPath().toFile());
    }

    public static class ProducerSpec {
        @Parameter(required=true)
        String name;
        @Parameter(required=true)
        String groupId;
        @Parameter(required=true)
        String artifactId;
        @Parameter(required=true)
        String versionRange;
    }
}

