/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemUnindentHandler;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListIndentBackspaceHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "deletedRange", "Lcom/intellij/openapi/util/TextRange;", "listItem", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "moveCaret", "", "beforeCharDeleted", "", "char", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "c", "indentLevels", "Lkotlin/sequences/Sequence;", "", "aboveItem", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownListIndentBackspaceHandlerDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListIndentBackspaceHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListIndentBackspaceHandlerDelegate\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,121:1\n1083#2,2:122\n1#3:124\n71#4:125\n*S KotlinDebug\n*F\n+ 1 MarkdownListIndentBackspaceHandlerDelegate.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListIndentBackspaceHandlerDelegate\n*L\n52#1:122,2\n78#1:125\n*E\n"})
public final class MarkdownListIndentBackspaceHandlerDelegate
extends BackspaceHandlerDelegate {
    @Nullable
    private TextRange deletedRange;
    @Nullable
    private MarkdownListItem listItem;
    private boolean moveCaret;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Object v4;
        int indent;
        int lineStart;
        block12: {
            boolean bl;
            int line;
            Document document;
            block11: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.deletedRange = null;
                this.listItem = null;
                this.moveCaret = false;
                if (!(file instanceof MarkdownFile) || !CharsKt.isWhitespace((char)c)) {
                    return;
                }
                if (!MarkdownCodeInsightSettings.Companion.getInstance().getState().getAdjustListIndentation()) {
                    return;
                }
                Document document2 = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                document = document2;
                PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(document);
                int caretOffset = editor2.getCaretModel().getOffset();
                line = document.getLineNumber(caretOffset);
                if (line == 0) {
                    return;
                }
                lineStart = document.getLineStartOffset(line);
                String string = document.getText(TextRange.create((int)lineStart, (int)caretOffset));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026(lineStart, caretOffset))");
                CharSequence $this$any$iv = string;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(!StringsKt.contains$default((CharSequence)"> \t", (char)it, (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            indent = editor2.getCaretModel().getLogicalPosition().column;
            if (indent == 0) {
                return;
            }
            MarkdownListItem item = ListUtils.INSTANCE.getListItemAtLine((MarkdownFile)file, line, document);
            if (item != null && document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item))) == line) {
                this.listItem = item;
                return;
            }
            MarkdownListItem markdownListItem = ListUtils.INSTANCE.getListItemAtLine((MarkdownFile)file, line - 1, document);
            if (markdownListItem == null && (markdownListItem = ListUtils.INSTANCE.getListItemAtLineSafely((MarkdownFile)file, line - 2, document)) == null) {
                return;
            }
            MarkdownListItem aboveItem = markdownListItem;
            if (indent + document.getLineStartOffset(line) > document.getLineEndOffset(line)) {
                this.moveCaret = true;
                return;
            }
            Sequence<Integer> sequence = this.indentLevels(aboveItem, document, file);
            for (Object e : sequence) {
                int it = ((Number)e).intValue();
                boolean bl3 = false;
                if (!(it < indent)) continue;
                v4 = e;
                break block12;
            }
            v4 = null;
        }
        Integer n = v4;
        if (n == null) {
            return;
        }
        int wantedIndent = n;
        this.deletedRange = TextRange.from((int)(lineStart + wantedIndent), (int)(indent - wantedIndent));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Integer> indentLevels(MarkdownListItem aboveItem, Document document, PsiFile file) {
        void $this$parentsOfType$iv;
        PsiElement psiElement = (PsiElement)aboveItem;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        return SequencesKt.map((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, MarkdownListItem.class, (boolean)withSelf$iv), (Function1)((Function1)new Function1<MarkdownListItem, Integer>(document, file){
            final /* synthetic */ Document $document;
            final /* synthetic */ PsiFile $file;
            {
                this.$document = $document;
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull MarkdownListItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int itemLine = this.$document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)it)));
                String string = ListUtils.INSTANCE.getLineIndentSpaces(this.$document, itemLine, this.$file);
                Intrinsics.checkNotNull((Object)string);
                return string.length();
            }
        }));
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (this.listItem != null) {
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(editor2, c){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ char $c;
                {
                    this.$editor = $editor;
                    this.$c = $c;
                    super(0);
                }

                public final void invoke() {
                    EditorModificationUtil.insertStringAtCaret((Editor)this.$editor, (String)String.valueOf(this.$c));
                }
            }));
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor2.getDocument());
            MarkdownListItemUnindentHandler unindentHandler = new MarkdownListItemUnindentHandler(null);
            unindentHandler.execute(editor2, editor2.getCaretModel().getCurrentCaret(), null);
            return true;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        if (this.moveCaret) {
            int line = document2.getLineNumber(editor2.getCaretModel().getOffset());
            editor2.getCaretModel().moveToOffset(document2.getLineEndOffset(line));
            return true;
        }
        TextRange textRange = this.deletedRange;
        if (textRange == null) {
            return false;
        }
        TextRange deletedRange = textRange;
        int line = document2.getLineNumber(editor2.getCaretModel().getOffset());
        TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document2, line);
        String string = ListUtils.INSTANCE.getLineIndentSpaces(document2, line, file);
        Intrinsics.checkNotNull((Object)string);
        String realIndent = string;
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(indentRange, document2, line, file, editor2, realIndent, deletedRange){
            final /* synthetic */ TextRange $indentRange;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $line;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $realIndent;
            final /* synthetic */ TextRange $deletedRange;
            {
                this.$indentRange = $indentRange;
                this.$document = $document;
                this.$line = $line;
                this.$file = $file;
                this.$editor = $editor;
                this.$realIndent = $realIndent;
                this.$deletedRange = $deletedRange;
                super(0);
            }

            public final void invoke() {
                int n = this.$indentRange.getLength();
                Integer n2 = ListUtils.INSTANCE.getLineIndentInnerSpacesLength(this.$document, this.$line, this.$file);
                Intrinsics.checkNotNull((Object)n2);
                if (n < n2) {
                    this.$editor.getDocument().replaceString(this.$indentRange.getStartOffset(), this.$indentRange.getEndOffset(), (CharSequence)this.$realIndent);
                }
                this.$editor.getDocument().deleteString(this.$deletedRange.getStartOffset(), this.$deletedRange.getEndOffset() - 1);
            }
        }));
        return true;
    }
}

