/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ClipboardUtils;", "", "()V", "CELL_BREAK", "", "LINE_BREAK", "copyAllToClipboard", "", "table", "Ljavax/swing/JTable;", "cellBreak", "limit", "", "copyAllToString", "copyImageToClipboard", "image", "Ljava/awt/Image;", "copySelectedToClipboard", "copySelectedToString", "escape", "cell", "ImageTransferable", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nClipboardUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClipboardUtils.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/ClipboardUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class ClipboardUtils {
    @NotNull
    public static final ClipboardUtils INSTANCE = new ClipboardUtils();
    @NotNull
    public static final String LINE_BREAK = "\r";
    @NotNull
    private static final String CELL_BREAK = "\t";

    private ClipboardUtils() {
    }

    private final String copyAllToString(JTable table, String cellBreak, int limit) {
        if (table.getRowCount() == 0 || table.getColumnCount() == 0) {
            Notifications.Bus.notify((Notification)new Notification("Notebook Table", VisualizationBundle.INSTANCE.message("clipboard.utils.error", new Object[0]), VisualizationBundle.INSTANCE.message("clipboard.utils.no.columns.or.rows", new Object[0]), NotificationType.ERROR));
            return "";
        }
        StringBuilder builder2 = new StringBuilder();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (i >= limit) {
                Object[] objectArray = new Object[]{limit};
                builder2.append("\n").append(VisualizationBundle.INSTANCE.message("clipboard.utils.copy.load.limit", objectArray));
                break;
            }
            int n2 = table.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                if (table.getValueAt(i, j) != null) {
                    Object it;
                    boolean bl = false;
                    builder2.append(INSTANCE.escape(it, cellBreak));
                }
                if (j >= table.getColumnCount() - 1) continue;
                builder2.append(cellBreak);
            }
            if (i == table.getRowCount() - 1) continue;
            builder2.append(LINE_BREAK);
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    static /* synthetic */ String copyAllToString$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = CELL_BREAK;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        return clipboardUtils.copyAllToString(jTable, string, n);
    }

    public final void copyAllToClipboard(@NotNull JTable table, @NotNull String cellBreak, int limit) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        StringSelection sel = new StringSelection(this.copyAllToString(table, cellBreak, limit));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
    }

    public static /* synthetic */ void copyAllToClipboard$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = CELL_BREAK;
        }
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        clipboardUtils.copyAllToClipboard(jTable, string, n);
    }

    @NotNull
    public final String copySelectedToString(@NotNull JTable table, @NotNull String cellBreak) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        int selectedColumnCount = table.getSelectedColumnCount();
        int selectedRowCount = table.getSelectedRowCount();
        int[] selectedRows = table.getSelectedRows();
        int[] selectedColumns = table.getSelectedColumns();
        if (selectedColumnCount == 0 || selectedRowCount == 0) {
            Notifications.Bus.notify((Notification)new Notification("Notebook Table", VisualizationBundle.INSTANCE.message("clipboard.utils.error", new Object[0]), VisualizationBundle.INSTANCE.message("clipboard.utils.no.selection", new Object[0]), NotificationType.ERROR));
            return "";
        }
        StringBuilder builder2 = new StringBuilder();
        for (int i = 0; i < selectedRowCount; ++i) {
            for (int j = 0; j < selectedColumnCount; ++j) {
                if (table.getValueAt(selectedRows[i], selectedColumns[j]) != null) {
                    Object it;
                    boolean bl = false;
                    String cellString = selectedColumnCount > 1 ? INSTANCE.escape(it, cellBreak) : it.toString();
                    builder2.append(cellString);
                }
                if (j >= selectedColumnCount - 1) continue;
                builder2.append(cellBreak);
            }
            if (i == selectedRowCount - 1) continue;
            builder2.append(LINE_BREAK);
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public static /* synthetic */ String copySelectedToString$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = CELL_BREAK;
        }
        return clipboardUtils.copySelectedToString(jTable, string);
    }

    public final void copySelectedToClipboard(@NotNull JTable table, @NotNull String cellBreak) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        StringSelection sel = new StringSelection(this.copySelectedToString(table, cellBreak));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
    }

    public static /* synthetic */ void copySelectedToClipboard$default(ClipboardUtils clipboardUtils, JTable jTable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = CELL_BREAK;
        }
        clipboardUtils.copySelectedToClipboard(jTable, string);
    }

    @NotNull
    public final String escape(@NotNull Object cell, @NotNull String cellBreak) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)cellBreak, (String)"cellBreak");
        String cellString = cell.toString();
        return StringsKt.contains$default((CharSequence)cellString, (CharSequence)LINE_BREAK, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)cellString, (CharSequence)cellBreak, (boolean)false, (int)2, null) ? "\"" + StringUtil.escapeQuotes((String)cellString) + "\"" : cellString;
    }

    public static /* synthetic */ String escape$default(ClipboardUtils clipboardUtils, Object object, String string, int n, Object object2) {
        if ((n & 2) != 0) {
            string = CELL_BREAK;
        }
        return clipboardUtils.escape(object, string);
    }

    public final void copyImageToClipboard(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ImageTransferable transferable = new ImageTransferable(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/ClipboardUtils$ImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/Image;", "(Ljava/awt/Image;)V", "getTransferData", "", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "intellij.notebooks.visualization"})
    private static final class ImageTransferable
    implements Transferable {
        @NotNull
        private final Image image;

        public ImageTransferable(@NotNull Image image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.imageFlavor, (String)"imageFlavor");
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            return Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.imageFlavor);
        }

        @Override
        @NotNull
        public Object getTransferData(@NotNull DataFlavor flavor) {
            Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

