/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.peer;

import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/projector/awt/peer/PDesktopPeer;", "Ljava/awt/peer/DesktopPeer;", "()V", "browse", "", "url", "Ljava/net/URI;", "edit", "file", "Ljava/io/File;", "isSupported", "", "action", "Ljava/awt/Desktop$Action;", "mail", "mailtoURL", "open", "print", "Companion", "projector-awt-common"})
public final class PDesktopPeer
implements DesktopPeer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @Nullable
    private static Function1<? super String, Unit> browseUriCallback;

    @Override
    public boolean isSupported(@NotNull Desktop.Action action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Desktop.Action[] actionArray = new Desktop.Action[]{Desktop.Action.OPEN, Desktop.Action.EDIT, Desktop.Action.PRINT, Desktop.Action.MAIL, Desktop.Action.BROWSE};
        return SetsKt.setOf((Object[])actionArray).contains((Object)action);
    }

    @Override
    public void open(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "ignored open " + this.$file;
            }
        }, 1, null);
    }

    @Override
    public void edit(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "ignored edit " + this.$file;
            }
        }, 1, null);
    }

    @Override
    public void print(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(file){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "ignored print " + this.$file;
            }
        }, 1, null);
    }

    @Override
    public void mail(@NotNull URI mailtoURL) {
        Intrinsics.checkNotNullParameter((Object)mailtoURL, (String)"mailtoURL");
        Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(mailtoURL){
            final /* synthetic */ URI $mailtoURL;
            {
                this.$mailtoURL = $mailtoURL;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "ignored mail " + this.$mailtoURL;
            }
        }, 1, null);
    }

    @Override
    public void browse(@NotNull URI url) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Function1<? super String, Unit> function1 = browseUriCallback;
            if (function1 == null) {
                unit = null;
            } else {
                String string = url.toASCIIString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toASCIIString()");
                function1.invoke((Object)string);
                unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            Logger.DefaultImpls.debug$default(logger, null, (Function0)new Function0<String>(url){
                final /* synthetic */ URI $url;
                {
                    this.$url = $url;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "ignored browse " + this.$url;
                }
            }, 1, null);
        }
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(PDesktopPeer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0003\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/projector/awt/peer/PDesktopPeer$Companion;", "", "()V", "browseUriCallback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "link", "", "getBrowseUriCallback", "()Lkotlin/jvm/functions/Function1;", "setBrowseUriCallback", "(Lkotlin/jvm/functions/Function1;)V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "projector-awt-common"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Function1<String, Unit> getBrowseUriCallback() {
            return browseUriCallback;
        }

        public final void setBrowseUriCallback(@Nullable Function1<? super String, Unit> function1) {
            browseUriCallback = function1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

