/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.DomElement;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomConfiguration;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.plugin.MavenDomPluginModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public final class MavenPluginDomUtil {
    @Nullable
    public static MavenProject findMavenProject(@NotNull DomElement domElement) {
        XmlElement xmlElement;
        if (domElement == null) {
            MavenPluginDomUtil.$$$reportNull$$$0(0);
        }
        if ((xmlElement = domElement.getXmlElement()) == null) {
            return null;
        }
        PsiFile psiFile = xmlElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(psiFile.getProject()).findProject(file);
    }

    @Nullable
    public static MavenDomPluginModel getMavenPluginModel(DomElement element) {
        MavenProject mavenProject2;
        Project project2 = element.getManager().getProject();
        MavenDomPlugin pluginElement = (MavenDomPlugin)element.getParentOfType(MavenDomPlugin.class, false);
        if (pluginElement == null) {
            return null;
        }
        String groupId = pluginElement.getGroupId().getStringValue();
        String artifactId = pluginElement.getArtifactId().getStringValue();
        String version2 = pluginElement.getVersion().getStringValue();
        if (StringUtil.isEmpty((String)version2) && (mavenProject2 = MavenPluginDomUtil.findMavenProject(element)) != null) {
            for (MavenPlugin plugin : mavenProject2.getPlugins()) {
                if (!MavenArtifactUtil.isPluginIdEquals(groupId, artifactId, plugin.getGroupId(), plugin.getArtifactId())) continue;
                MavenId pluginMavenId = plugin.getMavenId();
                version2 = pluginMavenId.getVersion();
                break;
            }
        }
        return MavenPluginDomUtil.getMavenPluginModel(project2, groupId, artifactId, version2);
    }

    @Nullable
    public static MavenDomPluginModel getMavenPluginModel(Project project2, String groupId, String artifactId, String version2) {
        VirtualFile pluginXmlFile = MavenPluginDomUtil.getPluginXmlFile(project2, groupId, artifactId, version2);
        if (pluginXmlFile == null) {
            return null;
        }
        return MavenDomUtil.getMavenDomModel(project2, pluginXmlFile, MavenDomPluginModel.class);
    }

    public static boolean isPlugin(@NotNull MavenDomConfiguration configuration, @Nullable String groupId, @NotNull String artifactId) {
        MavenDomPlugin domPlugin;
        if (configuration == null) {
            MavenPluginDomUtil.$$$reportNull$$$0(1);
        }
        if (artifactId == null) {
            MavenPluginDomUtil.$$$reportNull$$$0(2);
        }
        if ((domPlugin = (MavenDomPlugin)configuration.getParentOfType(MavenDomPlugin.class, true)) == null) {
            return false;
        }
        return MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId);
    }

    public static boolean isPlugin(@NotNull MavenDomPlugin plugin, @Nullable String groupId, @NotNull String artifactId) {
        if (plugin == null) {
            MavenPluginDomUtil.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            MavenPluginDomUtil.$$$reportNull$$$0(4);
        }
        if (!artifactId.equals(plugin.getArtifactId().getStringValue())) {
            return false;
        }
        String pluginGroupId = plugin.getGroupId().getStringValue();
        if (groupId == null) {
            return pluginGroupId == null || pluginGroupId.equals("org.apache.maven.plugins") || pluginGroupId.equals("org.codehaus.mojo");
        }
        if (pluginGroupId == null && (groupId.equals("org.apache.maven.plugins") || groupId.equals("org.codehaus.mojo"))) {
            return true;
        }
        return groupId.equals(pluginGroupId);
    }

    @Nullable
    private static VirtualFile getPluginXmlFile(Project project2, String groupId, String artifactId, String version2) {
        Path file = MavenArtifactUtil.getArtifactNioPath(MavenProjectsManager.getInstance(project2).getLocalRepository(), groupId, artifactId, version2, "jar");
        VirtualFile pluginFile = LocalFileSystem.getInstance().findFileByNioFile(file);
        if (pluginFile == null) {
            return null;
        }
        VirtualFile pluginJarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(pluginFile);
        if (pluginJarRoot == null) {
            return null;
        }
        return pluginJarRoot.findFileByRelativePath("META-INF/maven/plugin.xml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/MavenPluginDomUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMavenProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPlugin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

