/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenResumeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(MavenResumeAction.class);
    private static final Set<String> PARAMS_DISABLING_RESUME = ContainerUtil.newHashSet((Object[])new String[]{"-rf", "-resume-from", "-pl", "-projects", "-am", "-also-make", "-amd", "-also-make-dependents"});
    public static final int STATE_INITIAL = 0;
    public static final int STATE_READING_PROJECT_LIST = 1;
    public static final int STATE_READING_PROJECT_LIST_OLD_MAVEN = 5;
    public static final int STATE_WAIT_FOR_BUILD = 2;
    public static final int STATE_WAIT_FOR______ = 3;
    public static final int STATE_WTF = -1;
    private final ProgramRunner myRunner;
    private final ExecutionEnvironment myEnvironment;
    private final MavenParsingContext myContext;
    private int myState = 0;
    private int myBuildingProjectIndex = 0;
    private final List<String> myMavenProjectNames = new ArrayList<String>();
    private String myResumeFromModuleName;
    private String myResumeModuleId;
    private String myMavenVersion;

    public MavenResumeAction(ProcessHandler processHandler, ProgramRunner runner, ExecutionEnvironment environment, MavenParsingContext context2) {
        super(RunnerBundle.message("maven.resume.from.title", new Object[0]), null, AllIcons.RunConfigurations.RerunFailedTests);
        this.myRunner = runner;
        this.myEnvironment = environment;
        this.myContext = context2;
        MavenRunConfiguration runConfiguration = (MavenRunConfiguration)environment.getRunProfile();
        this.myMavenVersion = MavenResumeAction.getMavenVersion(runConfiguration);
        if (VersionComparatorUtil.compare((String)this.myMavenVersion, (String)"3.5.3") < 0 || context2 == null) {
            processHandler.addProcessListener((ProcessListener)new LegacyMavenResumeProcessAdapter(runConfiguration));
        } else {
            processHandler.addProcessListener((ProcessListener)new MavenSpyResumeProcessAdapter(runConfiguration));
        }
    }

    private static String getMavenVersion(MavenRunConfiguration runConfiguration) {
        MavenGeneralSettings generalSettings = runConfiguration.getGeneralSettings();
        if (generalSettings == null) {
            MavenDistribution maven2 = MavenDistribution.fromSettings(runConfiguration.getProject());
            if (maven2 == null) {
                String version2 = MavenDistributionsCache.resolveEmbeddedMavenHome().getVersion();
                MavenLog.LOG.warn("Cannot determine maven version from run configuration and project settings, use embedded as version: " + version2);
                return version2;
            }
            return maven2.getVersion();
        }
        return MavenUtil.getMavenVersion(generalSettings.getEffectiveMavenHome());
    }

    private static boolean hasResumeFromParameter(MavenRunConfiguration runConfiguration) {
        List<String> goals2 = runConfiguration.getRunnerParameters().getGoals();
        return goals2.size() > 2 && "-rf".equals(goals2.get(goals2.size() - 2));
    }

    @Nullable
    private MavenProject findProjectByName(@NotNull String projectName) {
        if (projectName == null) {
            MavenResumeAction.$$$reportNull$$$0(0);
        }
        List<MavenProject> projects = MavenProjectsManager.getInstance(this.myEnvironment.getProject()).getProjects();
        MavenProject candidate = null;
        for (MavenProject mavenProject2 : projects) {
            if (!projectName.equals(mavenProject2.getName())) continue;
            if (candidate == null) {
                candidate = mavenProject2;
                continue;
            }
            return null;
        }
        if (candidate != null) {
            return candidate;
        }
        for (MavenProject mavenProject2 : projects) {
            String id = mavenProject2.getMavenId().getGroupId() + ":" + mavenProject2.getMavenId().getArtifactId() + ":" + mavenProject2.getPackaging();
            if (!projectName.contains(id)) continue;
            if (candidate == null) {
                candidate = mavenProject2;
                continue;
            }
            return null;
        }
        if (candidate != null) {
            return candidate;
        }
        for (MavenProject mavenProject2 : projects) {
            if (!projectName.equals(mavenProject2.getMavenId().getArtifactId())) continue;
            if (candidate == null) {
                candidate = mavenProject2;
                continue;
            }
            return null;
        }
        return candidate;
    }

    public static boolean isApplicable(@Nullable Project project2, JavaParameters javaParameters, MavenRunConfiguration runConfiguration) {
        if (MavenResumeAction.hasResumeFromParameter(runConfiguration)) {
            MavenRunConfiguration clonedRunConf = runConfiguration.clone();
            List<String> clonedGoals = clonedRunConf.getRunnerParameters().getGoals();
            clonedGoals.remove(clonedGoals.size() - 1);
            clonedGoals.remove(clonedGoals.size() - 1);
            try {
                javaParameters = clonedRunConf.createJavaParameters(project2);
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        for (String params : javaParameters.getProgramParametersList().getList()) {
            if (!PARAMS_DISABLING_RESUME.contains(params)) continue;
            return false;
        }
        return true;
    }

    private static void log(String message) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.error(message, (Throwable)new Exception());
        } else {
            LOG.warn(message, (Throwable)new Exception());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenResumeAction.$$$reportNull$$$0(1);
        }
        if (this.myResumeFromModuleName != null && this.myResumeModuleId != null) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setText(RunnerBundle.message("maven.resume.from.template", this.myResumeFromModuleName));
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MavenResumeAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenResumeAction.$$$reportNull$$$0(3);
        }
        Project project2 = this.myEnvironment.getProject();
        try {
            MavenRunConfiguration runConfiguration = ((MavenRunConfiguration)this.myEnvironment.getRunProfile()).clone();
            List<String> goals2 = runConfiguration.getRunnerParameters().getGoals();
            if (goals2.size() > 2 && "-rf".equals(goals2.get(goals2.size() - 2))) {
                goals2.set(goals2.size() - 1, this.myResumeModuleId);
            } else {
                goals2.add("-rf");
                goals2.add(this.myResumeModuleId);
            }
            runConfiguration.getRunnerParameters().setGoals(goals2);
            this.myRunner.execute(new ExecutionEnvironmentBuilder(this.myEnvironment).contentToReuse(null).runProfile((RunProfile)runConfiguration).build());
        }
        catch (RunCanceledByUserException runConfiguration) {
        }
        catch (ExecutionException e1) {
            Messages.showErrorDialog((Project)project2, (String)e1.getMessage(), (String)ExecutionBundle.message((String)"restart.error.message.title", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenResumeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenResumeAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProjectByName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class LegacyMavenResumeProcessAdapter
    extends ProcessAdapter {
        private final MavenRunConfiguration myRunConfiguration;

        LegacyMavenResumeProcessAdapter(MavenRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                LegacyMavenResumeProcessAdapter.$$$reportNull$$$0(0);
            }
            if (MavenResumeAction.this.myState == -1) {
                return;
            }
            if (event.getExitCode() == 0 && MavenResumeAction.this.myBuildingProjectIndex != MavenResumeAction.this.myMavenProjectNames.size()) {
                MavenResumeAction.log(String.format("Build was success, but not all project was build. Project build order: %s, build index: %d", MavenResumeAction.this.myMavenProjectNames, MavenResumeAction.this.myBuildingProjectIndex));
            }
            if (event.getExitCode() == 1 && MavenResumeAction.this.myBuildingProjectIndex > 0) {
                if (MavenResumeAction.this.myBuildingProjectIndex == 1 && !MavenResumeAction.hasResumeFromParameter(this.myRunConfiguration)) {
                    return;
                }
                MavenResumeAction.this.myResumeFromModuleName = MavenResumeAction.this.myMavenProjectNames.get(MavenResumeAction.this.myBuildingProjectIndex - 1);
                MavenProject mavenProject2 = MavenResumeAction.this.findProjectByName(MavenResumeAction.this.myResumeFromModuleName);
                if (mavenProject2 != null) {
                    MavenResumeAction.this.myResumeModuleId = mavenProject2.getMavenId().getGroupId() + ":" + mavenProject2.getMavenId().getArtifactId();
                }
            }
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                LegacyMavenResumeProcessAdapter.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                LegacyMavenResumeProcessAdapter.$$$reportNull$$$0(2);
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            String text = event.getText().trim();
            if (text.isEmpty()) {
                return;
            }
            String textWithoutInfo = "";
            if (text.startsWith("[INFO] ")) {
                textWithoutInfo = text.substring("[INFO] ".length()).trim();
            }
            switch (MavenResumeAction.this.myState) {
                case 0: {
                    if (textWithoutInfo.equals("Reactor build order:")) {
                        MavenResumeAction.this.myState = 5;
                        break;
                    }
                    if (!textWithoutInfo.equals("Reactor Build Order:")) break;
                    MavenResumeAction.this.myState = 1;
                    break;
                }
                case 1: {
                    if (textWithoutInfo.equals("------------------------------------------------------------------------")) {
                        MavenResumeAction.this.myState = 2;
                        break;
                    }
                    if (!textWithoutInfo.isEmpty()) {
                        MavenResumeAction.this.myMavenProjectNames.add(textWithoutInfo);
                        break;
                    }
                    if (MavenResumeAction.this.myMavenProjectNames.isEmpty()) break;
                    MavenResumeAction.this.myState = 3;
                    break;
                }
                case 5: {
                    if (textWithoutInfo.isEmpty()) break;
                    if (text.startsWith("[INFO]   ")) {
                        MavenResumeAction.this.myMavenProjectNames.add(textWithoutInfo);
                        break;
                    }
                    MavenResumeAction.this.myState = 2;
                    break;
                }
                case 2: {
                    if (textWithoutInfo.startsWith("Building ")) {
                        String projectName = textWithoutInfo.substring("Building ".length());
                        if (MavenResumeAction.this.myBuildingProjectIndex >= MavenResumeAction.this.myMavenProjectNames.size() || !projectName.startsWith(MavenResumeAction.this.myMavenProjectNames.get(MavenResumeAction.this.myBuildingProjectIndex))) {
                            MavenResumeAction.this.myState = -1;
                            MavenResumeAction.log(String.format("Invalid project building order. Defined order: %s, error index: %d, invalid line: %s", MavenResumeAction.this.myMavenProjectNames, MavenResumeAction.this.myBuildingProjectIndex, text));
                            break;
                        }
                        ++MavenResumeAction.this.myBuildingProjectIndex;
                    }
                    MavenResumeAction.this.myState = 3;
                    break;
                }
                case 3: {
                    if (!textWithoutInfo.equals("------------------------------------------------------------------------")) break;
                    MavenResumeAction.this.myState = 2;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenResumeAction$LegacyMavenResumeProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MavenSpyResumeProcessAdapter
    extends ProcessAdapter {
        private final MavenRunConfiguration myRunConfiguration;

        MavenSpyResumeProcessAdapter(MavenRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MavenSpyResumeProcessAdapter.$$$reportNull$$$0(0);
            }
            MavenResumeAction.this.myContext.getStartedProjects();
            if (event.getExitCode() == 0 && MavenResumeAction.this.myContext.getStartedProjects().size() != 0 && MavenResumeAction.this.myContext.getProjectsInReactor().size() != MavenResumeAction.this.myContext.getStartedProjects().size()) {
                MavenResumeAction.log(String.format("Build was success, but not all project was build. Project build order: %s, built projects: %s", MavenResumeAction.this.myContext.getProjectsInReactor(), MavenResumeAction.this.myContext.getStartedProjects()));
            }
            if (event.getExitCode() != 0) {
                if (MavenResumeAction.this.myContext.getStartedProjects().isEmpty()) {
                    return;
                }
                if (MavenResumeAction.this.myContext.getStartedProjects().size() == 1 && !MavenResumeAction.hasResumeFromParameter(this.myRunConfiguration)) {
                    return;
                }
                MavenResumeAction.this.myResumeModuleId = MavenResumeAction.this.myContext.getStartedProjects().get(MavenResumeAction.this.myContext.getStartedProjects().size() - 1);
                String[] splitted = MavenResumeAction.this.myResumeModuleId.split(":");
                MavenResumeAction.this.myResumeFromModuleName = splitted.length < 2 ? MavenResumeAction.this.myResumeModuleId : splitted[1];
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/execution/MavenResumeAction$MavenSpyResumeProcessAdapter", "processTerminated"));
        }
    }
}

