/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.navigator.structure.MavenNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.utils.MavenUIUtil;

abstract class MavenSimpleNode
extends CachingSimpleNode
implements MavenNode {
    private MavenSimpleNode myParent;
    private MavenProjectsStructure.ErrorLevel myErrorLevel = MavenProjectsStructure.ErrorLevel.NONE;
    private MavenProjectsStructure.ErrorLevel myTotalErrorLevel = null;
    protected final MavenProjectsStructure myMavenProjectsStructure;

    MavenSimpleNode(MavenProjectsStructure structure, MavenSimpleNode parent) {
        super(structure.getProject(), null);
        this.myMavenProjectsStructure = structure;
        this.setParent(parent);
    }

    public MavenNodeType getType() {
        return MavenNodeType.OTHER;
    }

    public void setParent(MavenSimpleNode parent) {
        this.myParent = parent;
    }

    public NodeDescriptor getParentDescriptor() {
        return this.myParent;
    }

    MavenProjectNode findParentProjectNode() {
        return (MavenProjectNode)ObjectUtils.doIfNotNull((Object)this.myParent, it -> it.findProjectNode());
    }

    @Override
    public MavenProjectNode findProjectNode() {
        MavenSimpleNode node2 = this;
        while (node2 != null && !(node2 instanceof MavenProjectNode)) {
            node2 = node2.myParent;
        }
        return (MavenProjectNode)((Object)node2);
    }

    public boolean isVisible() {
        return this.getDisplayKind() != MavenProjectsStructure.DisplayKind.NEVER;
    }

    public MavenProjectsStructure.DisplayKind getDisplayKind() {
        MavenProjectsStructure.MavenStructureDisplayMode displayMode = this.myMavenProjectsStructure.getDisplayMode();
        if (displayMode == MavenProjectsStructure.MavenStructureDisplayMode.SHOW_ALL) {
            return MavenProjectsStructure.DisplayKind.NORMAL;
        }
        if (displayMode == MavenProjectsStructure.MavenStructureDisplayMode.SHOW_PROJECTS && this.getType() == MavenNodeType.PROJECT) {
            return MavenProjectsStructure.DisplayKind.ALWAYS;
        }
        if (displayMode == MavenProjectsStructure.MavenStructureDisplayMode.SHOW_GOALS && this.getType() == MavenNodeType.GOAL) {
            return MavenProjectsStructure.DisplayKind.ALWAYS;
        }
        return MavenProjectsStructure.DisplayKind.NEVER;
    }

    protected SimpleNode[] buildChildren() {
        List<? extends MavenSimpleNode> children = this.doGetChildren();
        if (children.isEmpty()) {
            return NO_CHILDREN;
        }
        ArrayList<MavenSimpleNode> result2 = new ArrayList<MavenSimpleNode>();
        for (MavenSimpleNode mavenSimpleNode : children) {
            if (!mavenSimpleNode.isVisible()) continue;
            result2.add(mavenSimpleNode);
        }
        return (SimpleNode[])result2.toArray(new MavenSimpleNode[0]);
    }

    protected List<? extends MavenSimpleNode> doGetChildren() {
        return Collections.emptyList();
    }

    public synchronized void cleanUpCache() {
        super.cleanUpCache();
        this.myTotalErrorLevel = null;
    }

    protected void childrenChanged() {
        for (MavenSimpleNode each = this; each != null; each = (MavenSimpleNode)each.getParent()) {
            each.cleanUpCache();
        }
        this.myMavenProjectsStructure.updateUpTo((SimpleNode)this);
    }

    public synchronized MavenProjectsStructure.ErrorLevel getTotalErrorLevel() {
        if (this.myTotalErrorLevel == null) {
            this.myTotalErrorLevel = this.calcTotalErrorLevel();
        }
        return this.myTotalErrorLevel;
    }

    private MavenProjectsStructure.ErrorLevel calcTotalErrorLevel() {
        MavenProjectsStructure.ErrorLevel childrenErrorLevel = this.getChildrenErrorLevel();
        return childrenErrorLevel.compareTo(this.myErrorLevel) > 0 ? childrenErrorLevel : this.myErrorLevel;
    }

    public MavenProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        MavenProjectsStructure.ErrorLevel result2 = MavenProjectsStructure.ErrorLevel.NONE;
        for (SimpleNode each : this.getChildren()) {
            MavenProjectsStructure.ErrorLevel eachLevel = ((MavenSimpleNode)each).getTotalErrorLevel();
            if (eachLevel.compareTo(result2) <= 0) continue;
            result2 = eachLevel;
        }
        return result2;
    }

    public void setErrorLevel(MavenProjectsStructure.ErrorLevel level) {
        if (this.myErrorLevel == level) {
            return;
        }
        this.myErrorLevel = level;
        this.myMavenProjectsStructure.updateUpTo((SimpleNode)this);
    }

    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            MavenSimpleNode.$$$reportNull$$$0(0);
        }
        this.setNameAndTooltip(presentation, this.getName(), null);
    }

    protected void setNameAndTooltip(@NotNull PresentationData presentation, String name, @Nullable @NlsContexts.Tooltip String tooltip) {
        if (presentation == null) {
            MavenSimpleNode.$$$reportNull$$$0(1);
        }
        this.setNameAndTooltip(presentation, name, tooltip, (String)null);
    }

    protected void setNameAndTooltip(@NotNull PresentationData presentation, String name, @Nullable @NlsContexts.Tooltip String tooltip, @Nullable @NlsSafe String hint) {
        if (presentation == null) {
            MavenSimpleNode.$$$reportNull$$$0(2);
        }
        this.setNameAndTooltip(presentation, name, tooltip, this.getPlainAttributes());
        if (this.showDescription() && !StringUtil.isEmptyOrSpaces((String)hint)) {
            presentation.addText(" (" + hint + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public boolean showDescription() {
        return this.myMavenProjectsStructure.getDisplayMode() == MavenProjectsStructure.MavenStructureDisplayMode.SHOW_ALL;
    }

    protected void setNameAndTooltip(@NotNull PresentationData presentation, @NlsSafe String name, @Nullable @NlsContexts.Tooltip String tooltip, SimpleTextAttributes attributes) {
        if (presentation == null) {
            MavenSimpleNode.$$$reportNull$$$0(3);
        }
        presentation.clearText();
        presentation.addText(name, this.prepareAttributes(attributes));
        this.getTemplatePresentation().setTooltip(tooltip);
    }

    private SimpleTextAttributes prepareAttributes(SimpleTextAttributes from) {
        MavenProjectsStructure.ErrorLevel level = this.getTotalErrorLevel();
        JBColor waveColor = level == MavenProjectsStructure.ErrorLevel.NONE ? null : JBColor.RED;
        int style = from.getStyle();
        if (waveColor != null) {
            style |= 8;
        }
        return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), (Color)waveColor, style);
    }

    @Nullable
    @NonNls
    String getActionId() {
        return null;
    }

    @Nullable
    @NonNls
    String getMenuId() {
        return null;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return MavenNavigationUtil.createNavigatableForPom(this.getProject(), this.getVirtualFile());
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        String actionId = this.getActionId();
        if (actionId != null) {
            MavenUIUtil.executeAction(actionId, "Maven tool window", inputEvent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "presentation";
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/MavenSimpleNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setNameAndTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum MavenNodeType {
        PROJECT,
        GOAL,
        OTHER;

    }
}

