/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.openapi.util.Pair;
import icons.MavenIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.navigator.structure.GroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.ProfileNode;
import org.jetbrains.idea.maven.project.MavenProjectBundle;

class ProfilesNode
extends GroupNode {
    private final List<ProfileNode> myProfileNodes = new CopyOnWriteArrayList<ProfileNode>();

    ProfilesNode(MavenProjectsStructure structure, MavenSimpleNode parent) {
        super(structure, parent);
        this.getTemplatePresentation().setIcon(MavenIcons.ProfilesClosed);
    }

    @Override
    protected List<? extends MavenSimpleNode> doGetChildren() {
        return this.myProfileNodes;
    }

    public String getName() {
        return MavenProjectBundle.message("view.node.profiles", new Object[0]);
    }

    public void updateProfiles() {
        Collection<Pair<String, MavenProfileKind>> profiles2 = this.myMavenProjectsStructure.getProjectsManager().getProfilesWithStates();
        ArrayList<ProfileNode> newNodes = new ArrayList<ProfileNode>(profiles2.size());
        for (Pair<String, MavenProfileKind> each : profiles2) {
            ProfileNode node2 = this.findOrCreateNodeFor((String)each.first);
            node2.setState((MavenProfileKind)each.second);
            newNodes.add(node2);
        }
        this.myProfileNodes.clear();
        this.myProfileNodes.addAll(newNodes);
        this.sort(this.myProfileNodes);
        this.childrenChanged();
    }

    private ProfileNode findOrCreateNodeFor(String profileName) {
        for (ProfileNode each : this.myProfileNodes) {
            if (!each.getProfileName().equals(profileName)) continue;
            return each;
        }
        return new ProfileNode(this.myMavenProjectsStructure, this, profileName);
    }
}

