/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RemotePathTransformerFactory {
    public static final ExtensionPointName<RemotePathTransformerFactory> MAVEN_REMOTE_PATH_TRANSFORMER_EP_NAME = new ExtensionPointName("org.jetbrains.idea.maven.remotePathTransformerFactory");

    public static Transformer createForProject(@NotNull Project project2) {
        Object[] transformers;
        List aTransformers;
        if (project2 == null) {
            RemotePathTransformerFactory.$$$reportNull$$$0(0);
        }
        if ((aTransformers = ContainerUtil.filter((Object[])(transformers = (RemotePathTransformerFactory[])MAVEN_REMOTE_PATH_TRANSFORMER_EP_NAME.getExtensions()), factory -> factory.isApplicable(project2))).size() > 1) {
            Logger.getInstance(RemotePathTransformerFactory.class).warn("More than one RemotePathTransformer is applicable: " + aTransformers);
        }
        return aTransformers.isEmpty() ? Transformer.ID : ((RemotePathTransformerFactory)aTransformers.get(0)).createTransformer(project2);
    }

    public boolean isApplicable(@NotNull Project var1);

    public Transformer createTransformer(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/server/RemotePathTransformerFactory", "createForProject"));
    }

    public static interface Transformer {
        public static final Transformer ID = new Transformer(){

            @Override
            @Nullable
            public String toRemotePath(@NotNull String localPath) {
                if (localPath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return localPath;
            }

            @Override
            @Nullable
            public String toIdePath(@NotNull String remotePath) {
                if (remotePath == null) {
                    1.$$$reportNull$$$0(1);
                }
                return remotePath;
            }

            @Override
            public boolean canBeRemotePath(String s) {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localPath";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remotePath";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/server/RemotePathTransformerFactory$Transformer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toRemotePath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "toIdePath";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        @Nullable
        public String toRemotePath(@NotNull String var1);

        @Nullable
        public String toIdePath(@NotNull String var1);

        public boolean canBeRemotePath(String var1);

        @Contract(value="!null -> !null")
        @Nullable
        default public String toRemotePathOrSelf(@Nullable String localPath) {
            if (localPath == null) {
                return null;
            }
            String remotePath = this.toRemotePath(localPath);
            return remotePath != null ? remotePath : localPath;
        }
    }
}

