/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.collect.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollectorException;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.collect.internal.Maven30ArtifactRepositoryAdapter;
import org.apache.maven.shared.transfer.graph.DependencyNode;
import org.apache.maven.shared.transfer.graph.DependencyVisitor;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;

class Maven30DependencyNodeAdapter
implements DependencyNode {
    private org.sonatype.aether.graph.DependencyNode dependencyNode;

    Maven30DependencyNodeAdapter(org.sonatype.aether.graph.DependencyNode dependencyNode) {
        this.dependencyNode = dependencyNode;
    }

    @Override
    public org.apache.maven.artifact.Artifact getArtifact() {
        return this.getArtifact(this.dependencyNode.getDependency().getArtifact());
    }

    @Override
    public List<DependencyNode> getChildren() {
        List<org.sonatype.aether.graph.DependencyNode> aetherChildren = this.dependencyNode.getChildren();
        ArrayList<DependencyNode> children = new ArrayList<DependencyNode>(aetherChildren.size());
        for (org.sonatype.aether.graph.DependencyNode aetherChild : aetherChildren) {
            children.add(new Maven30DependencyNodeAdapter(aetherChild));
        }
        return children;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        List<RemoteRepository> aetherRepositories = this.dependencyNode.getRepositories();
        ArrayList<ArtifactRepository> mavenRepositories = new ArrayList<ArtifactRepository>(aetherRepositories.size());
        for (RemoteRepository aetherRepository : aetherRepositories) {
            mavenRepositories.add(new Maven30ArtifactRepositoryAdapter(aetherRepository));
        }
        return mavenRepositories;
    }

    @Override
    public Boolean getOptional() {
        return this.dependencyNode.getDependency().isOptional();
    }

    @Override
    public String getScope() {
        return this.dependencyNode.getDependency().getScope();
    }

    @Override
    public boolean accept(DependencyVisitor visitor) {
        block1: {
            org.sonatype.aether.graph.DependencyNode child;
            Maven30DependencyNodeAdapter node;
            if (!visitor.visitEnter(this)) break block1;
            Iterator<org.sonatype.aether.graph.DependencyNode> iterator = this.dependencyNode.getChildren().iterator();
            while (iterator.hasNext() && (node = new Maven30DependencyNodeAdapter(child = iterator.next())).accept(visitor)) {
            }
        }
        return visitor.visitLeave(this);
    }

    public int hashCode() {
        return this.dependencyNode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Maven30DependencyNodeAdapter other = (Maven30DependencyNodeAdapter)obj;
        return !(this.dependencyNode == null ? other.dependencyNode != null : !this.dependencyNode.equals(other.dependencyNode));
    }

    private org.apache.maven.artifact.Artifact getArtifact(Artifact aetherArtifact) {
        try {
            return (org.apache.maven.artifact.Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", Artifact.class, aetherArtifact);
        }
        catch (DependencyCollectorException e) {
            throw new RuntimeException(e);
        }
    }
}

