/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.repository.internal;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.apache.maven.shared.transfer.repository.RepositoryManagerException;
import org.apache.maven.shared.transfer.repository.internal.Invoker;
import org.apache.maven.shared.transfer.repository.internal.Maven302RepositoryManager;
import org.apache.maven.shared.transfer.repository.internal.Maven30RepositoryManager;
import org.apache.maven.shared.transfer.repository.internal.Maven31RepositoryManager;
import org.apache.maven.shared.transfer.repository.internal.MavenRepositoryManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=RepositoryManager.class)
class DefaultRepositoryManager
implements RepositoryManager,
Contextualizable {
    private PlexusContainer container;

    DefaultRepositoryManager() {
    }

    @Override
    public String getPathForLocalArtifact(ProjectBuildingRequest buildingRequest, Artifact artifact) {
        try {
            return this.getMavenRepositoryManager(buildingRequest).getPathForLocalArtifact(artifact);
        }
        catch (RepositoryManagerException | ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String getPathForLocalArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coor) {
        try {
            return this.getMavenRepositoryManager(buildingRequest).getPathForLocalArtifact(coor);
        }
        catch (RepositoryManagerException | ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public String getPathForLocalMetadata(ProjectBuildingRequest buildingRequest, ArtifactMetadata metadata) {
        if (metadata instanceof ProjectArtifactMetadata) {
            DefaultArtifactCoordinate pomCoordinate = new DefaultArtifactCoordinate();
            pomCoordinate.setGroupId(metadata.getGroupId());
            pomCoordinate.setArtifactId(metadata.getArtifactId());
            pomCoordinate.setVersion(metadata.getBaseVersion());
            pomCoordinate.setExtension("pom");
            return this.getPathForLocalArtifact(buildingRequest, pomCoordinate);
        }
        try {
            return this.getMavenRepositoryManager(buildingRequest).getPathForLocalMetadata(metadata);
        }
        catch (RepositoryManagerException | ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public ProjectBuildingRequest setLocalRepositoryBasedir(ProjectBuildingRequest buildingRequest, File basedir) {
        try {
            return this.getMavenRepositoryManager(buildingRequest).setLocalRepositoryBasedir(buildingRequest, basedir);
        }
        catch (RepositoryManagerException | ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public File getLocalRepositoryBasedir(ProjectBuildingRequest buildingRequest) {
        try {
            return this.getMavenRepositoryManager(buildingRequest).getLocalRepositoryBasedir();
        }
        catch (RepositoryManagerException | ComponentLookupException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private boolean isMaven31() {
        return this.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private boolean isMaven302() {
        return this.canFindCoreClass("org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory");
    }

    private boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private MavenRepositoryManager getMavenRepositoryManager(ProjectBuildingRequest buildingRequest) throws ComponentLookupException, RepositoryManagerException {
        if (this.isMaven31()) {
            org.eclipse.aether.RepositorySystem m31RepositorySystem = this.container.lookup(org.eclipse.aether.RepositorySystem.class);
            org.eclipse.aether.RepositorySystemSession session = (org.eclipse.aether.RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            return new Maven31RepositoryManager(m31RepositorySystem, session);
        }
        RepositorySystem m30RepositorySystem = this.container.lookup(RepositorySystem.class);
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        if (this.isMaven302()) {
            return new Maven302RepositoryManager(m30RepositorySystem, session);
        }
        return new Maven30RepositoryManager(m30RepositorySystem, session);
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }
}

