/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.PluginValidationManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;

@Singleton
@Named
class PlexusContainerDefaultDependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    PlexusContainerDefaultDependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor) {
        boolean pcdPresent = mojoDescriptor.getPluginDescriptor().getDependencies().stream().filter(d -> "org.codehaus.plexus".equals(d.getGroupId())).anyMatch(d -> "plexus-container-default".equals(d.getArtifactId()));
        if (pcdPresent) {
            this.pluginValidationManager.reportPluginValidationIssue(mavenSession, mojoDescriptor, "Plugin depends on plexus-container-default, which is EOL");
        }
    }
}

