/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.lang.ant.config.actions.ActivateAntToolWindowAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class AddAntBuildFile
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddAntBuildFile.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile[] contextFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (contextFiles == null || contextFiles.length == 0) {
            return;
        }
        AntConfiguration antConfiguration = AntConfiguration.getInstance(project);
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(List.of(contextFiles));
        for (AntBuildFile antBuildFile : antConfiguration.getBuildFileList()) {
            VirtualFile virtualFile = antBuildFile.getVirtualFile();
            if (virtualFile == null) continue;
            files.remove(virtualFile);
        }
        int filesAdded = 0;
        @Nls StringBuilder stringBuilder = new StringBuilder();
        for (VirtualFile file : files) {
            try {
                if (antConfiguration.addBuildFile(file) == null) continue;
                ++filesAdded;
            }
            catch (AntNoFileException ex) {
                String message = ex.getMessage();
                if (message == null || message.length() == 0) {
                    message = AntBundle.message("cannot.add.build.files.from.excluded.directories.error.message", ex.getFile().getPresentableUrl());
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(message);
            }
        }
        if (stringBuilder.length() > 0) {
            Messages.showWarningDialog((Project)project, (String)stringBuilder.toString(), (String)AntBundle.message("cannot.add.build.file.dialog.title", new Object[0]));
        }
        if (filesAdded > 0) {
            ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Ant");
            if (window == null) {
                window = ActivateAntToolWindowAction.Manager.createToolWindow(project);
            }
            window.activate(null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile[] files;
        if (e == null) {
            AddAntBuildFile.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            for (VirtualFile file : files) {
                XmlTag rootTag;
                XmlFile xmlFile;
                XmlDocument document;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (!(psiFile instanceof XmlFile) || (document = (xmlFile = (XmlFile)psiFile).getDocument()) == null || (rootTag = document.getRootTag()) == null || !"project".equals(rootTag.getName()) || AntConfigurationBase.getInstance(project).getAntBuildFile(psiFile) != null) continue;
                AddAntBuildFile.enable(presentation);
                return;
            }
        }
        AddAntBuildFile.disable(presentation);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddAntBuildFile.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static void enable(Presentation presentation) {
        presentation.setEnabledAndVisible(true);
    }

    private static void disable(Presentation presentation) {
        presentation.setEnabledAndVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/actions/AddAntBuildFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/actions/AddAntBuildFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

