/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class AntMessage {
    private final AntBuildMessageView.MessageType myType;
    @Priority
    private final int myPriority;
    @Nls
    private final String myText;
    @Nls
    private final String[] myTextLines;
    private final VirtualFile myFile;
    private final int myLine;
    private final int myColumn;

    public AntMessage(AntBuildMessageView.MessageType type, @Priority int priority, @Nls String text, VirtualFile file, int line, int column) {
        this.myType = type;
        this.myPriority = priority;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
        this.myText = text;
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.myText, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        this.myTextLines = ArrayUtilRt.toStringArray(lines);
    }

    public AntMessage(AntBuildMessageView.MessageType type, @Priority int priority, @Nls String[] lines, VirtualFile file, int line, int column) {
        this.myType = type;
        this.myPriority = priority;
        this.myFile = file;
        this.myLine = line;
        this.myColumn = column;
        this.myTextLines = lines;
        this.myText = StringUtil.join((String[])lines, (String)"\n");
    }

    public AntBuildMessageView.MessageType getType() {
        return this.myType;
    }

    @Priority
    public int getPriority() {
        return this.myPriority;
    }

    @Nls
    public String getText() {
        return this.myText;
    }

    @Nls
    public String[] getTextLines() {
        return this.myTextLines;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    public int getColumn() {
        return this.myColumn;
    }

    @NotNull
    public AntMessage withText(@NotNull @Nls String text) {
        if (text == null) {
            AntMessage.$$$reportNull$$$0(0);
        }
        return new AntMessage(this.getType(), this.getPriority(), text, this.getFile(), this.getLine(), this.getColumn());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ant/config/execution/AntMessage", "withText"));
    }

    public static @interface Priority {
    }
}

