/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomAntCallParam;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyProviderFinder;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PropertyResolver
extends PropertyProviderFinder {
    @NonNls
    private final String myPropertyName;
    private PropertiesProvider myResult;
    private final Set<String> myVariants;

    private PropertyResolver(@NotNull @NonNls String propertyName, DomElement contextElement) {
        if (propertyName == null) {
            PropertyResolver.$$$reportNull$$$0(0);
        }
        super(contextElement);
        this.myVariants = new HashSet<String>();
        this.myPropertyName = propertyName;
    }

    @Override
    public void visitAntDomAntCallParam(AntDomAntCallParam antCallParam) {
    }

    @NotNull
    public static PropertyData resolve(@NotNull AntDomProject project, @NotNull String propertyName, DomElement contextElement) {
        if (project == null) {
            PropertyResolver.$$$reportNull$$$0(1);
        }
        if (propertyName == null) {
            PropertyResolver.$$$reportNull$$$0(2);
        }
        PropertyResolver resolver = new PropertyResolver(propertyName, contextElement);
        resolver.execute(project, project.getDefaultTarget().getRawText());
        AntDomElement antDomElement = resolver.getContextElement();
        if (antDomElement instanceof PropertiesProvider) {
            PropertiesProvider provider = (PropertiesProvider)((Object)antDomElement);
            resolver.propertyProviderFound(provider);
        }
        PropertyData propertyData = resolver.getResult();
        if (propertyData == null) {
            PropertyResolver.$$$reportNull$$$0(3);
        }
        return propertyData;
    }

    @NotNull
    public PropertyData getResult() {
        PsiElement element = this.myResult != null ? this.myResult.getNavigationElement(this.myPropertyName) : null;
        return new PropertyData(element, Collections.unmodifiableSet(this.myVariants), this.myResult);
    }

    @Override
    protected void propertyProviderFound(PropertiesProvider propertiesProvider) {
        boolean found = false;
        Iterator<String> it = propertiesProvider.getNamesIterator();
        while (it.hasNext()) {
            String providerProperty = it.next();
            this.myVariants.add(providerProperty);
            if (!this.myPropertyName.equals(providerProperty)) continue;
            found = true;
        }
        if (found) {
            this.myResult = propertiesProvider;
            this.stop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/PropertyResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/PropertyResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public record PropertyData(PsiElement element, Collection<String> variants, PropertiesProvider provider) {
    }
}

