/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow;

import com.intellij.collaboration.ui.toolwindow.ToolwindowUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.config.GithubPullRequestsProjectUISettings;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListLoader;
import org.jetbrains.plugins.github.pullrequest.ui.list.GHPRListComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.list.GHPRListPanelFactory;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRCommitBrowserComponentController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRToolWindowRepositoryContentController;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPRViewComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.MultiTabGHPRToolWindowRepositoryContentControllerKt;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.TabType;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.create.GHPRCreateComponentHolder;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0016R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/MultiTabGHPRToolWindowRepositoryContentController;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRToolWindowRepositoryContentController;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lorg/jetbrains/plugins/github/util/GHHostedRepositoriesManager;", "projectSettings", "Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "toolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/util/GHHostedRepositoriesManager;Lorg/jetbrains/plugins/github/pullrequest/config/GithubPullRequestsProjectUISettings;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lcom/intellij/openapi/wm/ToolWindow;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "Lorg/jetbrains/annotations/NotNull;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "createAndAddListContent", "Lcom/intellij/ui/content/Content;", "createAndAddNewPRContent", "createAndAddPRContent", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "createListPanel", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "createPullRequest", "", "requestFocus", "", "openPullRequestDiff", "openPullRequestTimeline", "resetNewPullRequestView", "viewList", "viewPullRequest", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRCommitBrowserComponentController;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nMultiTabGHPRToolWindowRepositoryContentController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTabGHPRToolWindowRepositoryContentController.kt\norg/jetbrains/plugins/github/pullrequest/ui/toolwindow/MultiTabGHPRToolWindowRepositoryContentController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1549#2:186\n1620#2,3:187\n1549#2:190\n1620#2,3:191\n*S KotlinDebug\n*F\n+ 1 MultiTabGHPRToolWindowRepositoryContentController.kt\norg/jetbrains/plugins/github/pullrequest/ui/toolwindow/MultiTabGHPRToolWindowRepositoryContentController\n*L\n64#1:186\n64#1:187,3\n98#1:190\n98#1:191,3\n*E\n"})
public final class MultiTabGHPRToolWindowRepositoryContentController
implements GHPRToolWindowRepositoryContentController {
    @NotNull
    private final Project project;
    @NotNull
    private final GHHostedRepositoriesManager repositoryManager;
    @NotNull
    private final GithubPullRequestsProjectUISettings projectSettings;
    @NotNull
    private final GHPRDataContext dataContext;
    @NotNull
    private final ContentManager contentManager;
    @NotNull
    private final GHRepositoryCoordinates repository;

    public MultiTabGHPRToolWindowRepositoryContentController(@NotNull Project project, @NotNull GHHostedRepositoriesManager repositoryManager, @NotNull GithubPullRequestsProjectUISettings projectSettings, @NotNull GHPRDataContext dataContext, @NotNull ToolWindow toolwindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repositoryManager, (String)"repositoryManager");
        Intrinsics.checkNotNullParameter((Object)projectSettings, (String)"projectSettings");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)toolwindow, (String)"toolwindow");
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.projectSettings = projectSettings;
        this.dataContext = dataContext;
        ContentManager contentManager = toolwindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolwindow.contentManager");
        this.contentManager = contentManager;
        this.repository = this.dataContext.getRepositoryDataService().getRepositoryCoordinates();
        ToolwindowUtilsKt.refreshReviewListOnSelection((ToolWindow)toolwindow, (Function1)1.INSTANCE);
    }

    @Override
    @NotNull
    public GHRepositoryCoordinates getRepository() {
        return this.repository;
    }

    @Override
    public void createPullRequest(boolean requestFocus) {
        Content content2;
        Object object;
        block2: {
            Content[] contentArray = this.contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)MultiTabGHPRToolWindowRepositoryContentControllerKt.access$getType(it), (Object)TabType.New.INSTANCE)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        if ((content2 = (Content)object) == null) {
            content2 = this.createAndAddNewPRContent();
        }
        Content content3 = content2;
        this.contentManager.setSelectedContent(content3, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logNewPRViewOpened(this.project);
    }

    /*
     * WARNING - void declaration
     */
    private final Content createAndAddNewPRContent() {
        Content content2;
        Object $this$mapTo$iv$iv;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable contentDisposable = disposable;
        Iterable $this$map$iv = HostedGitRepositoriesManagerKt.getKnownRepositories((HostedGitRepositoriesManager)this.repositoryManager);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void p0;
            GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getRepository());
        }
        List allRepos = (List)destination$iv$iv;
        $this$mapTo$iv$iv = new Object[]{GHUIUtil.getRepositoryDisplayName$default(GHUIUtil.INSTANCE, allRepos, this.dataContext.getRepositoryDataService().getRepositoryCoordinates(), false, 4, null)};
        String string = GithubBundle.message("tab.title.pull.requests.new", $this$mapTo$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"tab.title.pull.\u2026e.repositoryCoordinates))");
        String title = string;
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance()");
        $this$mapTo$iv$iv = new GHPRCreateComponentHolder(actionManager, this.project, this.projectSettings, this.repositoryManager, this.dataContext, this, contentDisposable).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTo$iv$iv, (String)"GHPRCreateComponentHolde\u2026tentDisposable).component");
        Object component2 = $this$mapTo$iv$iv;
        Content $this$createAndAddNewPRContent_u24lambda_u241 = content2 = this.contentManager.getFactory().createContent((JComponent)component2, title, false);
        boolean bl = false;
        $this$createAndAddNewPRContent_u24lambda_u241.setDisposer(contentDisposable);
        $this$createAndAddNewPRContent_u24lambda_u241.setCloseable(true);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createAndAddNewPRContent_u24lambda_u241, (String)"createAndAddNewPRContent$lambda$1");
        MultiTabGHPRToolWindowRepositoryContentControllerKt.access$setType($this$createAndAddNewPRContent_u24lambda_u241, TabType.New.INSTANCE);
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentManager.factory.c\u2026 type = TabType.New\n    }");
        Content content4 = content3;
        this.contentManager.addContent(content4);
        return content4;
    }

    @Override
    public void resetNewPullRequestView() {
        Object object;
        block2: {
            Content[] contentArray = this.contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)MultiTabGHPRToolWindowRepositoryContentControllerKt.access$getType(it), (Object)TabType.New.INSTANCE)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        Content content2 = (Content)object;
        if (content2 == null) {
            return;
        }
        Content content3 = content2;
        this.contentManager.removeContent(content3, true);
    }

    @Override
    public void viewList(boolean requestFocus) {
        Content content2;
        Object object;
        block2: {
            Content[] contentArray = this.contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)MultiTabGHPRToolWindowRepositoryContentControllerKt.access$getType(it), (Object)TabType.List.INSTANCE)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        if ((content2 = (Content)object) == null) {
            content2 = this.createAndAddListContent();
        }
        Content content3 = content2;
        this.contentManager.setSelectedContent(content3, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logListOpened(this.project);
    }

    /*
     * WARNING - void declaration
     */
    private final Content createAndAddListContent() {
        Content content2;
        void $this$mapTo$iv$iv;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable contentDisposable = disposable;
        Iterable $this$map$iv = HostedGitRepositoriesManagerKt.getKnownRepositories((HostedGitRepositoriesManager)this.repositoryManager);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getRepository());
        }
        List allRepos = (List)destination$iv$iv;
        String title = GHUIUtil.getRepositoryDisplayName$default(GHUIUtil.INSTANCE, allRepos, this.dataContext.getRepositoryDataService().getRepositoryCoordinates(), false, 4, null);
        JComponent component2 = this.createListPanel(contentDisposable);
        Content $this$createAndAddListContent_u24lambda_u245 = content2 = this.contentManager.getFactory().createContent(component2, title, false);
        boolean bl = false;
        $this$createAndAddListContent_u24lambda_u245.setPinned(true);
        $this$createAndAddListContent_u24lambda_u245.setCloseable(false);
        $this$createAndAddListContent_u24lambda_u245.setDisposer(contentDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createAndAddListContent_u24lambda_u245, (String)"createAndAddListContent$lambda$5");
        MultiTabGHPRToolWindowRepositoryContentControllerKt.access$setType($this$createAndAddListContent_u24lambda_u245, TabType.List.INSTANCE);
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentManager.factory.c\u2026type = TabType.List\n    }");
        Content content4 = content3;
        this.contentManager.addContent(content4);
        return content4;
    }

    private final JComponent createListPanel(Disposable disposable) {
        GHPRListLoader listLoader = this.dataContext.getListLoader();
        CollectionListModel listModel = new CollectionListModel(listLoader.getLoadedData());
        listLoader.addDataListener(disposable, new GHListLoader.ListDataListener(listLoader, (CollectionListModel<GHPullRequestShort>)listModel){
            final /* synthetic */ GHPRListLoader $listLoader;
            final /* synthetic */ CollectionListModel<GHPullRequestShort> $listModel;
            {
                this.$listLoader = $listLoader;
                this.$listModel = $listModel;
            }

            public void onDataAdded(int startIdx) {
                List loadedData = this.$listLoader.getLoadedData();
                this.$listModel.add(((ArrayList)loadedData).subList(startIdx, ((ArrayList)loadedData).size()));
            }

            public void onDataUpdated(int idx) {
                this.$listModel.setElementAt(((ArrayList)this.$listLoader.getLoadedData()).get(idx), idx);
            }

            public void onDataRemoved(@NotNull Object data) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    GHPullRequestShort gHPullRequestShort = data instanceof GHPullRequestShort ? (GHPullRequestShort)data : null;
                    if (gHPullRequestShort == null) break block0;
                    GHPullRequestShort gHPullRequestShort2 = gHPullRequestShort;
                    CollectionListModel<GHPullRequestShort> collectionListModel = this.$listModel;
                    GHPullRequestShort it = gHPullRequestShort2;
                    boolean bl = false;
                    collectionListModel.remove((Object)it);
                }
            }

            public void onAllDataRemoved() {
                this.$listModel.removeAll();
            }
        });
        JBList<GHPullRequestShort> list = new GHPRListComponentFactory((ListModel)listModel).create(this.dataContext.getAvatarIconsProvider());
        return new GHPRListPanelFactory(this.project, this.dataContext.getRepositoryDataService(), this.dataContext.getSecurityService(), this.dataContext.getListLoader(), this.dataContext.getListUpdatesChecker(), this.dataContext.getSecurityService().getAccount(), disposable).create(list, this.dataContext.getAvatarIconsProvider());
    }

    @Override
    @Nullable
    public GHPRCommitBrowserComponentController viewPullRequest(@NotNull GHPRIdentifier id, boolean requestFocus) {
        GHPRCommitBrowserComponentController gHPRCommitBrowserComponentController;
        Content content2;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Content[] contentArray = this.contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                TabType tabType = MultiTabGHPRToolWindowRepositoryContentControllerKt.access$getType(it);
                TabType.PR pR = tabType instanceof TabType.PR ? (TabType.PR)tabType : null;
                if (!Intrinsics.areEqual((Object)(pR != null ? pR.getId() : null), (Object)id)) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        if ((content2 = (Content)object) == null) {
            content2 = this.createAndAddPRContent(id);
        }
        Content content3 = content2;
        this.contentManager.setSelectedContent(content3, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logDetailsOpened(this.project);
        ChangesTree changesTree = (ChangesTree)UIUtil.findComponentOfType((JComponent)content3.getComponent(), ChangesTree.class);
        if (changesTree != null) {
            ChangesTree it = changesTree;
            boolean bl = false;
            gHPRCommitBrowserComponentController = (GHPRCommitBrowserComponentController)ClientProperty.get((Component)((Component)it), GHPRCommitBrowserComponentController.Companion.getKEY());
        } else {
            gHPRCommitBrowserComponentController = null;
        }
        return gHPRCommitBrowserComponentController;
    }

    private final Content createAndAddPRContent(GHPRIdentifier id) {
        Content content2;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable contentDisposable = disposable;
        String title = "#" + id.getNumber();
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance()");
        JComponent component2 = new GHPRViewComponentFactory(actionManager, this.project, this.dataContext, id, contentDisposable).create();
        Content $this$createAndAddPRContent_u24lambda_u248 = content2 = this.contentManager.getFactory().createContent(component2, title, false);
        boolean bl = false;
        $this$createAndAddPRContent_u24lambda_u248.setDisposer(contentDisposable);
        $this$createAndAddPRContent_u24lambda_u248.setCloseable(true);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createAndAddPRContent_u24lambda_u248, (String)"createAndAddPRContent$lambda$8");
        MultiTabGHPRToolWindowRepositoryContentControllerKt.access$setType($this$createAndAddPRContent_u24lambda_u248, new TabType.PR(id));
        Content content3 = content2;
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"contentManager.factory.c\u2026pe = TabType.PR(id)\n    }");
        Content content4 = content3;
        this.contentManager.addContent(content4);
        return content4;
    }

    @Override
    public void openPullRequestTimeline(@NotNull GHPRIdentifier id, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.dataContext.getFilesManager().createAndOpenTimelineFile(id, requestFocus);
    }

    @Override
    public void openPullRequestDiff(@NotNull GHPRIdentifier id, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.dataContext.getFilesManager().createAndOpenDiffFile(id, requestFocus);
    }
}

