/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012*\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000b0\b\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\"H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$H\u0014J\b\u0010%\u001a\u0004\u0018\u00010\tJ\b\u0010&\u001a\u00020\u0006H\u0007J\b\u0010'\u001a\u00020\u0006H\u0014J\b\u0010(\u001a\u00020\u0006H\u0014J\b\u0010)\u001a\u00020\u001fH\u0016J\b\u0010*\u001a\u00020\u0006H\u0007J\b\u0010+\u001a\u00020\u0006H\u0007J\u0006\u0010,\u001a\u00020\fJ\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020\u0006H\u0007J\n\u00102\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u00103\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0012H\u0002R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\t0\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubShareDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "existingRemotes", "", "", "accountInformationSupplier", "Lkotlin/Function2;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Ljava/awt/Component;", "Lkotlin/Pair;", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Lkotlin/jvm/functions/Function2;)V", "GITHUB_REPO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "accountInformationLoadingError", "Lcom/intellij/openapi/ui/ValidationInfo;", "accounts", "accountsModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "descriptionTextArea", "Lcom/intellij/ui/components/JBTextArea;", "existingRemoteValidator", "Lorg/jetbrains/plugins/github/ui/util/DialogValidationUtils$RecordUniqueValidator;", "existingRepoValidator", "privateCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "remoteName", "remoteTextField", "Lcom/intellij/ui/components/JBTextField;", "repositoryTextField", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "doValidateAll", "", "getAccount", "getDescription", "getDimensionServiceKey", "getHelpId", "getPreferredFocusedComponent", "getRemoteName", "getRepositoryName", "isPrivate", "switchAccount", "", "account", "testSetRepositoryName", "name", "validateRemote", "validateRepository", "validateRepositoryName", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubShareDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubShareDialog.kt\norg/jetbrains/plugins/github/ui/GithubShareDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class GithubShareDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Function2<GithubAccount, Component, Pair<Boolean, Set<String>>> accountInformationSupplier;
    private final Pattern GITHUB_REPO_PATTERN;
    @NotNull
    private final JBTextField repositoryTextField;
    @NotNull
    private final JBCheckBox privateCheckBox;
    @NlsSafe
    @NotNull
    private final String remoteName;
    @NotNull
    private final JBTextField remoteTextField;
    @NotNull
    private final JBTextArea descriptionTextArea;
    @NotNull
    private final DialogValidationUtils.RecordUniqueValidator existingRepoValidator;
    @NotNull
    private final DialogValidationUtils.RecordUniqueValidator existingRemoteValidator;
    @Nullable
    private ValidationInfo accountInformationLoadingError;
    @NotNull
    private final Set<GithubAccount> accounts;
    @NotNull
    private final CollectionComboBoxModel<GithubAccount> accountsModel;

    /*
     * WARNING - void declaration
     */
    public GithubShareDialog(@NotNull Project project, @NotNull Set<String> existingRemotes, @NotNull Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>> accountInformationSupplier) {
        void $this$existingRemoteValidator_u24lambda_u241;
        Object $this$descriptionTextArea_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(existingRemotes, (String)"existingRemotes");
        Intrinsics.checkNotNullParameter(accountInformationSupplier, (String)"accountInformationSupplier");
        super(project);
        this.project = project;
        this.accountInformationSupplier = accountInformationSupplier;
        this.GITHUB_REPO_PATTERN = Pattern.compile("[a-zA-Z0-9_.-]+");
        this.repositoryTextField = new JBTextField(this.project.getName());
        this.privateCheckBox = new JBCheckBox(GithubBundle.message("share.dialog.private", new Object[0]), true);
        this.remoteName = existingRemotes.isEmpty() ? "origin" : "github";
        this.remoteTextField = new JBTextField(this.remoteName);
        JBTextArea jBTextArea = object = new JBTextArea();
        GithubShareDialog githubShareDialog = this;
        boolean bl = false;
        $this$descriptionTextArea_u24lambda_u240.setLineWrap(true);
        githubShareDialog.descriptionTextArea = object;
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.error.repo.with.selected.name.exists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"share.error.rep\u2026th.selected.name.exists\")");
        this.existingRepoValidator = new DialogValidationUtils.RecordUniqueValidator(jTextField, string);
        JTextField jTextField2 = (JTextField)this.remoteTextField;
        String string2 = GithubBundle.message("share.error.remote.with.selected.name.exists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"share.error.rem\u2026th.selected.name.exists\")");
        $this$descriptionTextArea_u24lambda_u240 = object = new DialogValidationUtils.RecordUniqueValidator(jTextField2, string2);
        githubShareDialog = this;
        boolean bl2 = false;
        $this$existingRemoteValidator_u24lambda_u241.setRecords(existingRemotes);
        githubShareDialog.existingRemoteValidator = object;
        this.accounts = GHAccountsUtil.getAccounts();
        List list = CollectionsKt.toMutableList((Collection)this.accounts);
        GithubAccount githubAccount = GHAccountsUtil.getDefaultAccount(this.project);
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.firstOrNull((Iterable)this.accounts));
        }
        this.accountsModel = new CollectionComboBoxModel(list, (Object)githubAccount);
        this.setTitle(GithubBundle.message("share.on.github", new Object[0]));
        this.setOKButtonText(GithubBundle.message("share.button", new Object[0]));
        this.init();
        DialogUtils.invokeLaterAfterDialogShown((DialogWrapper)this, () -> GithubShareDialog._init_$lambda$2(this));
    }

    private final void switchAccount(GithubAccount account) {
        if (account == null) {
            return;
        }
        try {
            this.accountInformationLoadingError = null;
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
            Pair it = (Pair)this.accountInformationSupplier.invoke((Object)account, (Object)window);
            boolean bl = false;
            this.privateCheckBox.setEnabled(((Boolean)it.getFirst()).booleanValue());
            if (!((Boolean)it.getFirst()).booleanValue()) {
                this.privateCheckBox.setToolTipText(GithubBundle.message("share.error.private.repos.not.supported", new Object[0]));
            } else {
                this.privateCheckBox.setToolTipText(null);
            }
            this.existingRepoValidator.setRecords((Set)it.getSecond());
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{account};
            String errorText = GithubBundle.message("share.dialog.account.info.load.error.prefix", objectArray) + (e instanceof ProcessCanceledException ? GithubBundle.message("share.dialog.account.info.load.process.canceled", new Object[0]) : e.getMessage());
            this.accountInformationLoadingError = new ValidationInfo(errorText);
            this.privateCheckBox.setEnabled(false);
            this.privateCheckBox.setToolTipText(null);
            this.existingRepoValidator.setRecords(SetsKt.emptySet());
            this.startTrackingValidation();
        }
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel $this$createCenterPanel_u24lambda_u244 = dialogPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GithubShareDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = GithubBundle.message("share.dialog.repo.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"share.dialog.repo.name\")");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GithubShareDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)GithubShareDialog.access$getRepositoryTextField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)new Function2<ValidationInfoBuilder, JBTextField, ValidationInfo>(this.this$0){
                            final /* synthetic */ GithubShareDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull JBTextField it) {
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return GithubShareDialog.access$validateRepository(this.this$0);
                            }
                        }).resizableColumn();
                        $this$row.cell((JComponent)GithubShareDialog.access$getPrivateCheckBox$p(this.this$0));
                    }
                });
                String string2 = GithubBundle.message("share.dialog.remote", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"share.dialog.remote\")");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GithubShareDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)GithubShareDialog.access$getRemoteTextField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)new Function2<ValidationInfoBuilder, JBTextField, ValidationInfo>(this.this$0){
                            final /* synthetic */ GithubShareDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            @Nullable
                            public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull JBTextField it) {
                                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return GithubShareDialog.access$validateRemote(this.this$0);
                            }
                        });
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GithubShareDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GithubBundle.message("share.dialog.description", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"share.dialog.description\")");
                        $this$row.label(string).align((Align)AlignY.TOP.INSTANCE);
                        $this$row.scrollCell((JComponent)GithubShareDialog.access$getDescriptionTextArea$p(this.this$0)).align(Align.FILL);
                    }
                }), (int)1, null).layout(RowLayout.LABEL_ALIGNED).resizableRow();
                if (GithubShareDialog.access$getAccountsModel$p(this.this$0).getSize() != 1) {
                    String string3 = GithubBundle.message("share.dialog.share.by", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"share.dialog.share.by\")");
                    $this$panel.row(string3, (Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ GithubShareDialog this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)GithubShareDialog.access$getAccountsModel$p(this.this$0)), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)new Function2<ValidationInfoBuilder, ComboBox<GithubAccount>, ValidationInfo>(this.this$0){
                                final /* synthetic */ GithubShareDialog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                @Nullable
                                public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull ComboBox<GithubAccount> it) {
                                    ValidationInfo validationInfo;
                                    Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    if (GithubShareDialog.access$getAccountsModel$p(this.this$0).getSelected() == null) {
                                        String string = GithubBundle.message("dialog.message.account.cannot.be.empty", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dialog.message.account.cannot.be.empty\")");
                                        validationInfo = $this$validationOnApply.error(string);
                                    } else {
                                        validationInfo = null;
                                    }
                                    return validationInfo;
                                }
                            }).applyToComponent((Function1)new Function1<ComboBox<GithubAccount>, Unit>(this.this$0){
                                final /* synthetic */ GithubShareDialog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull ComboBox<GithubAccount> $this$applyToComponent) {
                                    Intrinsics.checkNotNullParameter($this$applyToComponent, (String)"$this$applyToComponent");
                                    $this$applyToComponent.addActionListener(arg_0 -> createCenterPanel.2.invoke$lambda$0(this.this$0, arg_0));
                                }

                                private static final void invoke$lambda$0(GithubShareDialog this$0, ActionEvent it) {
                                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                                    GithubShareDialog.access$switchAccount(this$0, this$0.getAccount());
                                }
                            }).resizableColumn();
                            if (GithubShareDialog.access$getAccountsModel$p(this.this$0).getSize() == 0) {
                                $this$row.cell((JComponent)GHAccountsUtil.INSTANCE.createAddAccountLink(GithubShareDialog.access$getProject$p(this.this$0), (CollectionComboBoxModel<GithubAccount>)GithubShareDialog.access$getAccountsModel$p(this.this$0)));
                            }
                        }
                    });
                }
            }
        }));
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u244.setPreferredSize((Dimension)JBUI.size((int)500, (int)250));
        return dialogPanel;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List list = super.doValidateAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"super.doValidateAll()");
        List uiErrors = list;
        ValidationInfo loadingError = this.accountInformationLoadingError;
        return loadingError != null ? CollectionsKt.plus((Collection)uiErrors, (Object)loadingError) : uiErrors;
    }

    private final ValidationInfo validateRepository() {
        JTextField jTextField = (JTextField)this.repositoryTextField;
        String string = GithubBundle.message("share.validation.no.repo.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"share.validation.no.repo.name\")");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null && (validationInfo = this.validateRepositoryName()) == null) {
            validationInfo = this.existingRepoValidator.invoke();
        }
        return validationInfo;
    }

    private final ValidationInfo validateRepositoryName() {
        return this.GITHUB_REPO_PATTERN.matcher(this.repositoryTextField.getText()).matches() ? null : new ValidationInfo(GithubBundle.message("share.validation.invalid.repo.name", new Object[0]), (JComponent)this.repositoryTextField);
    }

    private final ValidationInfo validateRemote() {
        JTextField jTextField = (JTextField)this.remoteTextField;
        String string = GithubBundle.message("share.validation.no.remote.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"share.validation.no.remote.name\")");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null) {
            validationInfo = this.existingRemoteValidator.invoke();
        }
        return validationInfo;
    }

    @NotNull
    protected String getHelpId() {
        return "github.share";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.ShareDialog";
    }

    @NotNull
    public JBTextField getPreferredFocusedComponent() {
        return this.repositoryTextField;
    }

    @NlsSafe
    @NotNull
    public final String getRepositoryName() {
        String string = this.repositoryTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repositoryTextField.text");
        return string;
    }

    @NlsSafe
    @NotNull
    public final String getRemoteName() {
        String string = this.remoteTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"remoteTextField.text");
        return string;
    }

    public final boolean isPrivate() {
        return this.privateCheckBox.isSelected();
    }

    @NlsSafe
    @NotNull
    public final String getDescription() {
        String string = this.descriptionTextArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptionTextArea.text");
        return string;
    }

    @Nullable
    public final GithubAccount getAccount() {
        return (GithubAccount)((Object)this.accountsModel.getSelected());
    }

    @TestOnly
    public final void testSetRepositoryName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.repositoryTextField.setText(name);
    }

    private static final void _init_$lambda$2(GithubShareDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.switchAccount(this$0.getAccount());
    }

    public static final /* synthetic */ JBTextField access$getRepositoryTextField$p(GithubShareDialog $this) {
        return $this.repositoryTextField;
    }

    public static final /* synthetic */ ValidationInfo access$validateRepository(GithubShareDialog $this) {
        return $this.validateRepository();
    }

    public static final /* synthetic */ JBCheckBox access$getPrivateCheckBox$p(GithubShareDialog $this) {
        return $this.privateCheckBox;
    }

    public static final /* synthetic */ JBTextField access$getRemoteTextField$p(GithubShareDialog $this) {
        return $this.remoteTextField;
    }

    public static final /* synthetic */ ValidationInfo access$validateRemote(GithubShareDialog $this) {
        return $this.validateRemote();
    }

    public static final /* synthetic */ JBTextArea access$getDescriptionTextArea$p(GithubShareDialog $this) {
        return $this.descriptionTextArea;
    }

    public static final /* synthetic */ CollectionComboBoxModel access$getAccountsModel$p(GithubShareDialog $this) {
        return $this.accountsModel;
    }

    public static final /* synthetic */ void access$switchAccount(GithubShareDialog $this, GithubAccount account) {
        $this.switchAccount(account);
    }

    public static final /* synthetic */ Project access$getProject$p(GithubShareDialog $this) {
        return $this.project;
    }
}

