/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFix
implements IntentionAction {
    public boolean startInWriteAction() {
        return true;
    }

    protected static void moveTo(Editor editor, XmlTag xmlTag) {
        editor.getCaretModel().moveToOffset(xmlTag.getTextRange().getStartOffset());
    }

    protected static TemplateBuilderImpl createTemplateBuilder(XmlTag xmlTag) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)xmlTag.getProject()).createFileFromText("dummy.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)xmlTag.getText(), LocalTimeCounter.currentTime(), true, false);
        return new TemplateBuilderImpl((PsiElement)psiFile);
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AbstractFix.$$$reportNull$$$0(0);
        }
        if (this.requiresEditor() && editor == null) {
            return false;
        }
        return this.isAvailableImpl(project, editor, file);
    }

    protected abstract boolean isAvailableImpl(@NotNull Project var1, @Nullable Editor var2, PsiFile var3);

    protected abstract boolean requiresEditor();

    @Nullable
    public LocalQuickFix createQuickFix(boolean isOnTheFly) {
        final boolean requiresEditor = this.requiresEditor();
        if (requiresEditor && !isOnTheFly) {
            return null;
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = AbstractFix.this.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = AbstractFix.this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiFile psiFile;
                Editor editor;
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (requiresEditor) {
                    DataContext dataContext = DataManager.getInstance().getDataContext();
                    editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    if (editor == null && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                        return;
                    }
                } else {
                    editor = null;
                }
                if (!AbstractFix.this.isAvailable(project, editor, psiFile = descriptor.getPsiElement().getContainingFile())) {
                    return;
                }
                AbstractFix.this.invoke(project, editor, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public static @NotNull LocalQuickFix @NotNull [] createFixes(LocalQuickFix ... fixes) {
        if (fixes == null) {
            AbstractFix.$$$reportNull$$$0(1);
        }
        List result = ContainerUtil.findAll((Object[])fixes, localQuickFix -> localQuickFix != null);
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            AbstractFix.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

