/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.baseline;

import com.jetbrains.qodana.sarif.baseline.ResultKey;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class BaselineCalculation {
    public static final String EQUAL_INDICATOR = "equalIndicator";
    private int newResults = 0;
    private int absentResults = 0;
    private int unchangedResults = 0;
    private final Options options;

    private BaselineCalculation(Options options) {
        this.options = options;
    }

    public static BaselineCalculation compare(SarifReport report2, SarifReport baseline, Options options) {
        BaselineCalculation result = new BaselineCalculation(options);
        result.fillBaselineState(report2, baseline);
        return result;
    }

    public static BaselineCalculation compare(SarifReport report2, SarifReport baseline) {
        return BaselineCalculation.compare(report2, baseline, Options.DEFAULT);
    }

    public int getNewResults() {
        return this.newResults;
    }

    public int getAbsentResults() {
        return this.absentResults;
    }

    public int getUnchangedResults() {
        return this.unchangedResults;
    }

    public void fillBaselineState(SarifReport report2, SarifReport baseline) {
        List<Run> baselineRunsField = baseline.getRuns();
        ArrayList<Run> baselineRuns = baselineRunsField != null ? new ArrayList<Run>(baselineRunsField) : Collections.emptyList();
        ArrayList<Run> unmatched = new ArrayList<Run>();
        for (Run run2 : report2.getRuns()) {
            Optional<Run> first = baselineRuns.stream().filter(it -> Objects.equals(this.getToolName((Run)it), this.getToolName(run2))).findFirst();
            if (first.isPresent()) {
                Run baselineRun = first.get();
                new RunResultGroup(run2, baselineRun).build();
                baselineRuns.remove(baselineRun);
                continue;
            }
            unmatched.add(run2);
        }
        for (int i = 0; i < unmatched.size(); ++i) {
            Run baselineRun;
            Run run2;
            run2 = (Run)unmatched.get(i);
            Run run3 = baselineRun = i < baselineRuns.size() ? (Run)baselineRuns.get(i) : null;
            if (baselineRun == null) {
                this.markRunAsNew(run2);
                continue;
            }
            new RunResultGroup(run2, baselineRun).build();
        }
    }

    private void markRunAsNew(Run run2) {
        for (Result result : run2.getResults()) {
            this.setBaselineState(result, Result.BaselineState.NEW);
            ++this.newResults;
        }
    }

    private String getToolName(Run run2) {
        Tool tool = run2.getTool();
        if (tool == null) {
            return null;
        }
        ToolComponent driver = tool.getDriver();
        if (driver == null) {
            return null;
        }
        return driver.getName();
    }

    private void setBaselineState(Result result, Result.BaselineState state) {
        result.setBaselineState(state);
    }

    private class RunResultGroup {
        private final Map<String, Result> baselineHashes = new HashMap<String, Result>();
        private final Map<String, Result> reportHashes = new HashMap<String, Result>();
        private final Map<ResultKey, List<Result>> diffBaseline = new HashMap<ResultKey, List<Result>>();
        private final Map<ResultKey, List<Result>> diffReport = new HashMap<ResultKey, List<Result>>();
        private final Run report;

        public RunResultGroup(Run report2, Run baseline) {
            this.report = report2;
            this.buildMap(baseline, this.baselineHashes, this.diffBaseline);
            this.removeProblemsWithState(report2, Result.BaselineState.ABSENT);
            this.buildMap(report2, this.reportHashes, this.diffReport);
        }

        private void removeProblemsWithState(Run report2, Result.BaselineState state) {
            report2.getResults().removeIf(result -> result.getBaselineState() == state);
        }

        private void buildMap(Run run2, Map<String, Result> map2, Map<ResultKey, List<Result>> diffSet) {
            for (Result result : run2.getResults()) {
                String equalIndicator;
                if (result.getBaselineState() == Result.BaselineState.ABSENT) continue;
                VersionedMap<String> fingerprints = result.getPartialFingerprints();
                String string = equalIndicator = fingerprints != null ? fingerprints.getLastValue(BaselineCalculation.EQUAL_INDICATOR) : null;
                if (equalIndicator != null) {
                    map2.put(equalIndicator, result);
                    continue;
                }
                this.addToDiff(result, diffSet);
            }
        }

        public void addToDiff(Result result, Map<ResultKey, List<Result>> diffSet) {
            List resultBucket = diffSet.compute(new ResultKey(result), (key, value) -> value != null ? value : new ArrayList());
            resultBucket.add(result);
        }

        public void build() {
            this.reportHashes.forEach((hash, result) -> {
                if (this.baselineHashes.containsKey(hash)) {
                    BaselineCalculation.this.setBaselineState(result, Result.BaselineState.UNCHANGED);
                    BaselineCalculation.this.unchangedResults++;
                } else {
                    this.addToDiff((Result)result, this.diffReport);
                }
            });
            this.baselineHashes.forEach((hash, result) -> {
                if (!this.reportHashes.containsKey(hash)) {
                    if (((Boolean)BaselineCalculation.this.options.wasChecked.apply(result)).booleanValue()) {
                        this.addToDiff((Result)result, this.diffBaseline);
                    } else {
                        result.setBaselineState(Result.BaselineState.UNCHANGED);
                        this.report.getResults().add((Result)result);
                        BaselineCalculation.this.unchangedResults += 1;
                    }
                }
            });
            this.diffReport.forEach((key, reportDiffBucket) -> {
                List baselineDiffBucket = this.diffBaseline.getOrDefault(key, Collections.emptyList());
                for (Result result : reportDiffBucket) {
                    if (baselineDiffBucket.isEmpty()) {
                        BaselineCalculation.this.setBaselineState(result, Result.BaselineState.NEW);
                        BaselineCalculation.this.newResults++;
                        continue;
                    }
                    BaselineCalculation.this.setBaselineState(result, Result.BaselineState.UNCHANGED);
                    baselineDiffBucket.remove(baselineDiffBucket.size() - 1);
                    BaselineCalculation.this.unchangedResults++;
                }
            });
            this.diffBaseline.entrySet().stream().flatMap(it -> ((List)it.getValue()).stream()).forEach(result -> {
                if (((Boolean)BaselineCalculation.this.options.wasChecked.apply(result)).booleanValue()) {
                    if (BaselineCalculation.this.options.includeAbsent) {
                        BaselineCalculation.this.setBaselineState(result, Result.BaselineState.ABSENT);
                        BaselineCalculation.this.absentResults++;
                        this.report.getResults().add((Result)result);
                    }
                } else {
                    result.setBaselineState(Result.BaselineState.UNCHANGED);
                    this.report.getResults().add((Result)result);
                    BaselineCalculation.this.unchangedResults += 1;
                }
            });
            if (!BaselineCalculation.this.options.includeUnchanged) {
                this.removeProblemsWithState(this.report, Result.BaselineState.UNCHANGED);
                BaselineCalculation.this.unchangedResults = 0;
            }
            if (!BaselineCalculation.this.options.fillBaselineState) {
                for (Result result2 : this.report.getResults()) {
                    result2.setBaselineState(null);
                }
            }
        }
    }

    public static class Options {
        public static final Options DEFAULT = new Options();
        private final boolean includeAbsent;
        private final boolean includeUnchanged;
        private final boolean fillBaselineState;
        private static final Function<Result, Boolean> ALL_CHECKED = result -> true;
        private final Function<Result, Boolean> wasChecked;

        public Options() {
            this.includeAbsent = false;
            this.includeUnchanged = true;
            this.fillBaselineState = true;
            this.wasChecked = ALL_CHECKED;
        }

        public Options(boolean includeAbsent) {
            this(includeAbsent, true, true);
        }

        public Options(boolean includeAbsent, boolean includeUnchanged, boolean fillBaselineState) {
            this.includeAbsent = includeAbsent;
            this.includeUnchanged = includeUnchanged;
            this.fillBaselineState = fillBaselineState;
            this.wasChecked = ALL_CHECKED;
        }

        public Options(boolean includeAbsent, boolean includeUnchanged, boolean fillBaselineState, Function<Result, Boolean> wasChecked) {
            this.includeAbsent = includeAbsent;
            this.includeUnchanged = includeUnchanged;
            this.fillBaselineState = fillBaselineState;
            this.wasChecked = wasChecked;
        }

        public boolean isIncludeAbsent() {
            return this.includeAbsent;
        }

        public boolean isIncludeUnchanged() {
            return this.includeUnchanged;
        }

        public boolean isFillBaselineState() {
            return this.fillBaselineState;
        }
    }
}

