/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.protocol;

import com.intellij.openapi.project.Project;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.report.AggregatedReportMetadata;
import org.jetbrains.qodana.report.BannerContentProvider;
import org.jetbrains.qodana.report.BrowserViewProvider;
import org.jetbrains.qodana.report.LoadedReport;
import org.jetbrains.qodana.report.LocalReportDescriptor;
import org.jetbrains.qodana.report.NoProblemsContentProvider;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.report.ValidatedSarif;
import org.jetbrains.qodana.ui.problemsView.viewModel.QodanaProblemsViewModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001+B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0019\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0011\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*R\u001c\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R$\u0010\u0014\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u00170\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lorg/jetbrains/qodana/protocol/SingleMarkerReportDescriptor;", "Lorg/jetbrains/qodana/report/LocalReportDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "sarif", "Lorg/jetbrains/qodana/report/ValidatedSarif;", "pathText", "", "reportRevision", "origin", "message", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/report/ValidatedSarif;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "bannerContentProviderFlow", "Lkotlinx/coroutines/flow/Flow;", "Lorg/jetbrains/qodana/report/BannerContentProvider;", "getBannerContentProviderFlow", "()Lkotlinx/coroutines/flow/Flow;", "browserViewProviderFlow", "Lorg/jetbrains/qodana/report/BrowserViewProvider;", "getBrowserViewProviderFlow", "isReportAvailableFlow", "Lkotlin/Function0;", "", "Lorg/jetbrains/qodana/report/NotificationCallback;", "noProblemsContentProviderFlow", "Lorg/jetbrains/qodana/report/NoProblemsContentProvider;", "getNoProblemsContentProviderFlow", "checkAvailability", "", "equals", "other", "", "getName", "highlightedState", "Lorg/jetbrains/qodana/report/LocalReportDescriptor$HighlightedState;", "hashCode", "", "loadReport", "Lorg/jetbrains/qodana/report/LoadedReport;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshReport", "Lorg/jetbrains/qodana/report/ReportDescriptor;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "NoProblemsContentProviderImpl", "intellij.qodana"})
public final class SingleMarkerReportDescriptor
implements LocalReportDescriptor {
    @NotNull
    private final Project project;
    @NotNull
    private final ValidatedSarif sarif;
    @NotNull
    private final String pathText;
    @Nullable
    private final String reportRevision;
    @NotNull
    private final String origin;
    @NotNull
    private final String message;
    @NotNull
    private final Flow<Function0<Unit>> isReportAvailableFlow;
    @NotNull
    private final Flow<BrowserViewProvider> browserViewProviderFlow;
    @NotNull
    private final Flow<BannerContentProvider> bannerContentProviderFlow;
    @NotNull
    private final Flow<NoProblemsContentProvider> noProblemsContentProviderFlow;

    public SingleMarkerReportDescriptor(@NotNull Project project2, @NotNull ValidatedSarif sarif, @NotNull String pathText, @Nullable String reportRevision, @NotNull String origin, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sarif, (String)"sarif");
        Intrinsics.checkNotNullParameter((Object)pathText, (String)"pathText");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.project = project2;
        this.sarif = sarif;
        this.pathText = pathText;
        this.reportRevision = reportRevision;
        this.origin = origin;
        this.message = message;
        this.isReportAvailableFlow = FlowKt.emptyFlow();
        this.browserViewProviderFlow = FlowKt.emptyFlow();
        this.bannerContentProviderFlow = FlowKt.emptyFlow();
        this.noProblemsContentProviderFlow = FlowKt.flowOf((Object)new NoProblemsContentProviderImpl());
    }

    @Override
    @NotNull
    public Flow<Function0<Unit>> isReportAvailableFlow() {
        return this.isReportAvailableFlow;
    }

    @Override
    @NotNull
    public Flow<BrowserViewProvider> getBrowserViewProviderFlow() {
        return this.browserViewProviderFlow;
    }

    @Override
    @NotNull
    public Flow<BannerContentProvider> getBannerContentProviderFlow() {
        return this.bannerContentProviderFlow;
    }

    @Override
    @NotNull
    public Flow<NoProblemsContentProvider> getNoProblemsContentProviderFlow() {
        return this.noProblemsContentProviderFlow;
    }

    @Override
    @Nullable
    public Object refreshReport(@NotNull Continuation<? super ReportDescriptor> $completion) {
        return this;
    }

    @Override
    public boolean checkAvailability() {
        return true;
    }

    @Override
    @NotNull
    public String getName(@NotNull LocalReportDescriptor.HighlightedState highlightedState) {
        Intrinsics.checkNotNullParameter((Object)((Object)highlightedState), (String)"highlightedState");
        return this.pathText + " - " + this.message;
    }

    @Override
    @Nullable
    public Object loadReport(@NotNull Project project2, @NotNull Continuation<? super LoadedReport> $completion) {
        return new LoadedReport(this.sarif, new AggregatedReportMetadata(MapsKt.emptyMap()));
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.pathText, this.origin, this.reportRevision};
        return Objects.hash(objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof SingleMarkerReportDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pathText, (Object)((SingleMarkerReportDescriptor)other).pathText) && Intrinsics.areEqual((Object)this.origin, (Object)((SingleMarkerReportDescriptor)other).origin) && Intrinsics.areEqual((Object)this.reportRevision, (Object)((SingleMarkerReportDescriptor)other).reportRevision);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/protocol/SingleMarkerReportDescriptor$NoProblemsContentProviderImpl;", "Lorg/jetbrains/qodana/report/NoProblemsContentProvider;", "(Lorg/jetbrains/qodana/protocol/SingleMarkerReportDescriptor;)V", "noProblemsContent", "Lorg/jetbrains/qodana/report/NoProblemsContentProvider$NoProblemsContent;", "noProblems", "qodanaProblemsViewModel", "Lorg/jetbrains/qodana/ui/problemsView/viewModel/QodanaProblemsViewModel;", "notMatchingProject", "totalProblemsCount", "", "intellij.qodana"})
    private final class NoProblemsContentProviderImpl
    implements NoProblemsContentProvider {
        @NotNull
        private final NoProblemsContentProvider.NoProblemsContent noProblemsContent;

        public NoProblemsContentProviderImpl() {
            String string = QodanaBundle.message("no.problems.content.show.marker.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"no.problems.content.show.marker.title\")");
            Object[] objectArray = new Object[]{SingleMarkerReportDescriptor.this.pathText, SingleMarkerReportDescriptor.this.project.getName()};
            this.noProblemsContent = new NoProblemsContentProvider.NoProblemsContent(string, QodanaBundle.message("no.problems.content.show.marker.description", objectArray), null);
        }

        @Override
        @NotNull
        public NoProblemsContentProvider.NoProblemsContent noProblems(@NotNull QodanaProblemsViewModel qodanaProblemsViewModel) {
            Intrinsics.checkNotNullParameter((Object)qodanaProblemsViewModel, (String)"qodanaProblemsViewModel");
            return this.noProblemsContent;
        }

        @Override
        @NotNull
        public NoProblemsContentProvider.NoProblemsContent notMatchingProject(@NotNull QodanaProblemsViewModel qodanaProblemsViewModel, int totalProblemsCount) {
            Intrinsics.checkNotNullParameter((Object)qodanaProblemsViewModel, (String)"qodanaProblemsViewModel");
            return this.noProblemsContent;
        }
    }
}

