/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.i18n;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NlsCapitalizationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.xml.util.XmlUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.OverrideText;
import org.jetbrains.idea.devkit.dom.Separator;
import org.jetbrains.idea.devkit.dom.Synonym;
import org.jetbrains.idea.devkit.i18n.DevKitI18nBundle;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;
import org.jetbrains.idea.devkit.util.DescriptorI18nUtil;

final class PluginXmlCapitalizationInspection
extends DevKitPluginXmlInspectionBase {
    private static final Set<String> EXTENSION_KNOWN_NON_NLS_ATTRIBUTES = Set.of("id", "order", "os");

    PluginXmlCapitalizationInspection() {
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            PluginXmlCapitalizationInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PluginXmlCapitalizationInspection.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            PluginXmlCapitalizationInspection.$$$reportNull$$$0(2);
        }
        if (!this.isAllowed(holder)) {
            return;
        }
        if (element instanceof ActionOrGroup) {
            PluginXmlCapitalizationInspection.checkActionOrGroup((ActionOrGroup)element, holder);
        } else if (element instanceof OverrideText) {
            PluginXmlCapitalizationInspection.checkOverrideText((OverrideText)element, holder);
        } else if (element instanceof Separator) {
            PluginXmlCapitalizationInspection.checkSeparator((Separator)element, holder);
        } else if (element instanceof Synonym) {
            PluginXmlCapitalizationInspection.checkSynonym((Synonym)element, holder);
        } else if (element instanceof Extension) {
            PluginXmlCapitalizationInspection.checkExtension((Extension)element, holder);
        } else if (element instanceof IdeaPlugin) {
            PluginXmlCapitalizationInspection.checkCapitalization(holder, ((IdeaPlugin)element).getName(), Nls.Capitalization.Title);
        }
    }

    private static void checkSeparator(Separator separator, DomElementAnnotationHolder holder) {
        if (PluginXmlCapitalizationInspection.checkCapitalization(holder, separator.getText(), Nls.Capitalization.Title)) {
            return;
        }
        PluginXmlCapitalizationInspection.checkCapitalizationWithKey(holder, separator.getKey(), Nls.Capitalization.Title);
    }

    private static void checkSynonym(Synonym synonym, DomElementAnnotationHolder holder) {
        if (PluginXmlCapitalizationInspection.checkCapitalization(holder, synonym.getText(), Nls.Capitalization.Title)) {
            return;
        }
        PluginXmlCapitalizationInspection.checkCapitalizationWithKey(holder, synonym.getKey(), Nls.Capitalization.Title);
    }

    private static void checkOverrideText(OverrideText overrideText, DomElementAnnotationHolder holder) {
        if (PluginXmlCapitalizationInspection.checkCapitalization(holder, overrideText.getText(), Nls.Capitalization.Title)) {
            return;
        }
        if (DomUtil.hasXml(overrideText.getUseTextOfPlace())) {
            return;
        }
        ActionOrGroup actionOrGroup = (ActionOrGroup)overrideText.getParentOfType(ActionOrGroup.class, true);
        assert (actionOrGroup != null);
        PluginXmlCapitalizationInspection.checkPropertyCapitalization(holder, overrideText, Nls.Capitalization.Title, ActionOrGroup.TextType.TEXT.getMessageKey(actionOrGroup, overrideText), true);
    }

    private static void checkActionOrGroup(ActionOrGroup actionOrGroup, DomElementAnnotationHolder holder) {
        PluginXmlCapitalizationInspection.checkActionOrGroupCapitalization(holder, actionOrGroup, ActionOrGroup.TextType.TEXT);
        PluginXmlCapitalizationInspection.checkActionOrGroupCapitalization(holder, actionOrGroup, ActionOrGroup.TextType.DESCRIPTION);
    }

    private static void checkActionOrGroupCapitalization(DomElementAnnotationHolder holder, ActionOrGroup actionOrGroup, ActionOrGroup.TextType textType) {
        Nls.Capitalization capitalization;
        GenericDomValue<String> genericDomValue = textType.getDomValue(actionOrGroup);
        if (PluginXmlCapitalizationInspection.checkCapitalization(holder, genericDomValue, capitalization = textType.getCapitalization())) {
            return;
        }
        PluginXmlCapitalizationInspection.checkPropertyCapitalization(holder, actionOrGroup, capitalization, textType.getMessageKey(actionOrGroup), textType.isRequired(actionOrGroup));
    }

    private static void checkPropertyCapitalization(DomElementAnnotationHolder holder, DomElement domElement, Nls.Capitalization capitalization, @NonNls @Nullable String resourceKey, boolean required) {
        if (resourceKey == null) {
            return;
        }
        PropertiesFile bundleFile = DescriptorI18nUtil.findBundlePropertiesFile(domElement);
        if (bundleFile == null) {
            return;
        }
        Property property = (Property)ObjectUtils.tryCast((Object)bundleFile.findPropertyByKey(resourceKey), Property.class);
        if (property == null) {
            if (required) {
                holder.createProblem(domElement, DevKitI18nBundle.message("inspections.plugin.xml.capitalization.missing.resource.bundle.key", resourceKey), new LocalQuickFix[0]);
            }
        } else {
            PluginXmlCapitalizationInspection.highlightCapitalization(holder, domElement, property.getValue(), capitalization, property);
        }
    }

    private static void checkExtension(Extension extension, DomElementAnnotationHolder holder) {
        for (DomChildrenDescription child : extension.getGenericInfo().getFixedChildrenDescriptions()) {
            for (DomElement value : child.getValues((DomElement)extension)) {
                if (!value.exists() || !(value instanceof GenericDomValue)) continue;
                GenericDomValue genericDomValue = (GenericDomValue)value;
                PluginXmlCapitalizationInspection.checkDomValue(extension, holder, child, genericDomValue);
            }
        }
        List attributes = extension.getGenericInfo().getAttributeChildrenDescriptions();
        if (attributes.size() == EXTENSION_KNOWN_NON_NLS_ATTRIBUTES.size() + 1) {
            return;
        }
        for (DomAttributeChildDescription attributeDescription : attributes) {
            GenericAttributeValue attributeValue;
            String attributeName = attributeDescription.getXmlElementName();
            if (EXTENSION_KNOWN_NON_NLS_ATTRIBUTES.contains(attributeName) || Extension.isClassField(attributeName) || !DomUtil.hasXml((DomElement)(attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension)))) continue;
            PluginXmlCapitalizationInspection.checkDomValue(extension, holder, (DomChildrenDescription)attributeDescription, (GenericDomValue)attributeValue);
        }
    }

    private static void checkDomValue(Extension extension, DomElementAnnotationHolder holder, DomChildrenDescription childrenDescription, GenericDomValue genericDomValue) {
        Class attributeType = DomUtil.getGenericValueParameter((Type)childrenDescription.getType());
        if (attributeType != String.class) {
            return;
        }
        PsiElement declaration = childrenDescription.getDeclaration(extension.getManager().getProject());
        if (declaration instanceof PsiModifierListOwner) {
            Nls.Capitalization capitalization = NlsInfo.getCapitalization((PsiModifierListOwner)((PsiModifierListOwner)declaration));
            if (capitalization == Nls.Capitalization.NotSpecified) {
                return;
            }
            PluginXmlCapitalizationInspection.checkCapitalizationWithKey(holder, genericDomValue, capitalization);
        }
    }

    private static void checkCapitalizationWithKey(DomElementAnnotationHolder holder, GenericDomValue genericDomValue, Nls.Capitalization capitalization) {
        if (!DomUtil.hasXml((DomElement)genericDomValue)) {
            return;
        }
        XmlElement xmlElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        if (xmlElement == null) {
            return;
        }
        for (PsiReference reference : xmlElement.getReferences()) {
            PsiElement element;
            if (!(reference instanceof PropertyReference)) continue;
            ResolveResult[] resolveResults = ((PropertyReference)reference).multiResolve(false);
            if (resolveResults.length == 1 && resolveResults[0].isValidResult() && (element = resolveResults[0].getElement()) instanceof Property) {
                Property property = (Property)element;
                String value = property.getValue();
                PluginXmlCapitalizationInspection.highlightCapitalization(holder, (DomElement)genericDomValue, value, capitalization, property);
                return;
            }
            return;
        }
        PluginXmlCapitalizationInspection.checkCapitalization(holder, genericDomValue, capitalization);
    }

    private static boolean checkCapitalization(DomElementAnnotationHolder holder, GenericDomValue genericDomValue, Nls.Capitalization capitalization) {
        if (!DomUtil.hasXml((DomElement)genericDomValue)) {
            return false;
        }
        String stringValue = genericDomValue.getStringValue();
        PluginXmlCapitalizationInspection.highlightCapitalization(holder, (DomElement)genericDomValue, stringValue, capitalization, null);
        return true;
    }

    private static void highlightCapitalization(DomElementAnnotationHolder holder, DomElement domElement, String value, Nls.Capitalization capitalization, @Nullable Property property) {
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return;
        }
        @NlsSafe String escapedValue = XmlUtil.unescape((String)value).replace("_", "");
        if (NlsCapitalizationUtil.isCapitalizationSatisfied((String)escapedValue, (Nls.Capitalization)capitalization)) {
            return;
        }
        FixCapitalizationFixBase quickFix = property != null ? new FixPropertyCapitalizationFix(property, escapedValue, capitalization) : new FixDomValueCapitalizationFix(escapedValue, capitalization);
        holder.createProblem(domElement, DevKitI18nBundle.message("inspections.plugin.xml.capitalization.error", escapedValue, capitalization == Nls.Capitalization.Title ? 0 : 1), new LocalQuickFix[]{quickFix});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlCapitalizationInspection";
        objectArray[2] = "checkDomElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FixPropertyCapitalizationFix
    extends FixCapitalizationFixBase {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final SmartPsiElementPointer<Property> myPropertyPointer;

        private FixPropertyCapitalizationFix(Property property, String value, Nls.Capitalization capitalization) {
            super(value, capitalization);
            this.myPropertyPointer = SmartPointerManager.createPointer((PsiElement)property);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Property property;
            if (project == null) {
                FixPropertyCapitalizationFix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                FixPropertyCapitalizationFix.$$$reportNull$$$0(1);
            }
            if ((property = (Property)this.myPropertyPointer.getElement()) == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    FixPropertyCapitalizationFix.$$$reportNull$$$0(2);
                }
                return intentionPreviewInfo;
            }
            PsiFile containingFile = this.myPropertyPointer.getContainingFile();
            assert (containingFile != null);
            String propertyKey = property.getKey();
            String newValue = NlsCapitalizationUtil.fixValue((String)this.myValue, (Nls.Capitalization)this.myCapitalization);
            return new IntentionPreviewInfo.CustomDiff((FileType)PropertiesFileType.INSTANCE, containingFile.getName(), property.getText(), propertyKey + "=" + newValue);
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                FixPropertyCapitalizationFix.$$$reportNull$$$0(3);
            }
            return this.myPropertyPointer.getContainingFile();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Property propertyToFix;
            if (project == null) {
                FixPropertyCapitalizationFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                FixPropertyCapitalizationFix.$$$reportNull$$$0(5);
            }
            if ((propertyToFix = (Property)this.myPropertyPointer.getElement()) == null) {
                return;
            }
            propertyToFix.setValue(NlsCapitalizationUtil.fixValue((String)this.myValue, (Nls.Capitalization)this.myCapitalization));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlCapitalizationInspection$FixPropertyCapitalizationFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlCapitalizationInspection$FixPropertyCapitalizationFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class FixDomValueCapitalizationFix
    extends FixCapitalizationFixBase {
        private FixDomValueCapitalizationFix(String escapedValue, Nls.Capitalization capitalization) {
            super(escapedValue, capitalization);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            DomElement domElement;
            if (project == null) {
                FixDomValueCapitalizationFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                FixDomValueCapitalizationFix.$$$reportNull$$$0(1);
            }
            if (!((domElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement())) instanceof GenericDomValue)) {
                return;
            }
            ((GenericDomValue)domElement).setStringValue(NlsCapitalizationUtil.fixValue((String)this.myValue, (Nls.Capitalization)this.myCapitalization));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/devkit/i18n/PluginXmlCapitalizationInspection$FixDomValueCapitalizationFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class FixCapitalizationFixBase
    implements LocalQuickFix {
        protected final String myValue;
        protected final Nls.Capitalization myCapitalization;

        private FixCapitalizationFixBase(String value, Nls.Capitalization capitalization) {
            this.myValue = value;
            this.myCapitalization = capitalization;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = DevKitI18nBundle.message("inspections.plugin.xml.capitalization.fix.properly.capitalize", this.myValue);
            if (string == null) {
                FixCapitalizationFixBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitI18nBundle.message("inspections.plugin.xml.capitalization.fix.properly.capitalize.family.name", new Object[0]);
            if (string == null) {
                FixCapitalizationFixBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/devkit/i18n/PluginXmlCapitalizationInspection$FixCapitalizationFixBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

