/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UnsafeVfsRecursionInspection
extends DevKitUastInspectionBase {
    private static final String VIRTUAL_FILE_CLASS_NAME = VirtualFile.class.getName();
    private static final String GET_CHILDREN_METHOD_NAME = "getChildren";
    private static final String GET_CHILDREN_PROPERTY_ACCESS_NAME = "children";
    public static final Class<? extends UElement>[] HINTS = new Class[]{UCallExpression.class, UQualifiedReferenceExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                UnsafeVfsRecursionInspection.inspectExpression((UExpression)node, holder);
                return true;
            }

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                UnsafeVfsRecursionInspection.inspectExpression((UExpression)node, holder);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeVfsRecursionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQualifiedReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static void inspectExpression(@NotNull UExpression expression, @NotNull ProblemsHolder holder) {
        PsiElement sourcePsi;
        if (expression == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(3);
        }
        if (UnsafeVfsRecursionInspection.isVirtualFileGetChildrenMethodCall(expression) && UnsafeVfsRecursionInspection.isCalledInRecursiveMethod(expression) && (sourcePsi = expression.getSourcePsi()) != null) {
            holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.unsafe.vfs.recursion", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isVirtualFileGetChildrenMethodCall(@NotNull UExpression expression) {
        PsiMethod getChildrenMethod;
        if (expression == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(4);
        }
        if ((getChildrenMethod = UnsafeVfsRecursionInspection.tryToResolveGetChildrenMethod(expression)) == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)getChildrenMethod.getContainingClass(), (String)VIRTUAL_FILE_CLASS_NAME);
    }

    @Nullable
    private static PsiMethod tryToResolveGetChildrenMethod(@NotNull UExpression expression) {
        UCallExpression call;
        if (expression == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(5);
        }
        if (expression instanceof UCallExpression && (call = (UCallExpression)expression).isMethodNameOneOf(List.of(GET_CHILDREN_METHOD_NAME))) {
            return call.resolve();
        }
        if (expression instanceof UQualifiedReferenceExpression) {
            UQualifiedReferenceExpression qualifiedReference = (UQualifiedReferenceExpression)expression;
            PsiElement selectorPsi = qualifiedReference.getSelector().getSourcePsi();
            if (selectorPsi == null) {
                return null;
            }
            if (GET_CHILDREN_PROPERTY_ACCESS_NAME.equals(selectorPsi.getText())) {
                PsiElement resolveResult = qualifiedReference.resolve();
                return resolveResult instanceof PsiMethod ? (PsiMethod)resolveResult : null;
            }
        }
        return null;
    }

    private static boolean isCalledInRecursiveMethod(final @NotNull UExpression getChildrenMethodCall) {
        UMethod containingMethod;
        if (getChildrenMethodCall == null) {
            UnsafeVfsRecursionInspection.$$$reportNull$$$0(6);
        }
        if ((containingMethod = (UMethod)UastUtils.getParentOfType((UElement)getChildrenMethodCall, UMethod.class)) == null) {
            return false;
        }
        final String containingMethodName = containingMethod.getName();
        final Ref isInRecursiveCall = Ref.create();
        PsiElement methodSourcePsi = containingMethod.getSourcePsi();
        if (methodSourcePsi == null) {
            return false;
        }
        methodSourcePsi.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                UCallExpression potentialRecursiveCall = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
                if (potentialRecursiveCall == null) {
                    return;
                }
                if (!potentialRecursiveCall.isMethodNameOneOf(List.of(containingMethodName))) {
                    return;
                }
                if (potentialRecursiveCall != getChildrenMethodCall && 2.expressionResolvesToMethod(potentialRecursiveCall, containingMethod)) {
                    isInRecursiveCall.set((Object)Boolean.TRUE);
                }
            }

            private static boolean expressionResolvesToMethod(@NotNull UCallExpression potentialRecursiveCall, @NotNull UMethod uMethod) {
                PsiMethod resolvedMethod;
                if (potentialRecursiveCall == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (uMethod == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((resolvedMethod = potentialRecursiveCall.resolve()) == null) {
                    return false;
                }
                UElement resolvedUMethod = UastContextKt.toUElement((PsiElement)resolvedMethod);
                if (resolvedUMethod == null) {
                    return false;
                }
                return uMethod.getSourcePsi() == resolvedUMethod.getSourcePsi();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "potentialRecursiveCall";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uMethod";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeVfsRecursionInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "expressionResolvesToMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return Boolean.TRUE == isInRecursiveCall.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeVfsRecursionInspection";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getChildrenMethodCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeVfsRecursionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inspectExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVirtualFileGetChildrenMethodCall";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryToResolveGetChildrenMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCalledInRecursiveMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

