/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UseCoupleInspection
extends DevKitUastInspectionBase
implements CleanupLocalInspectionTool {
    private static final String PAIR_CLASS_NAME = Pair.class.getName();
    private static final String COUPLE_CLASS_NAME = Couple.class.getName();
    public static final Class<? extends UElement>[] HINTS = new Class[]{UDeclaration.class, UCallExpression.class};

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseCoupleInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitDeclaration(@NotNull UDeclaration node) {
                PsiElement sourcePsi;
                String pairTypeName;
                UTypeReferenceExpression typeReferenceExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((typeReferenceExpression = 1.getDeclarationTypeReferenceExpression(node)) != null && (pairTypeName = 1.getPairTypeParameterNameIfBothTheSame(typeReferenceExpression)) != null && (sourcePsi = typeReferenceExpression.getSourcePsi()) != null) {
                    LocalQuickFix[] localQuickFixArray;
                    String string = DevKitBundle.message("inspections.use.couple.type", pairTypeName);
                    if (node.getLang().is((Language)JavaLanguage.INSTANCE)) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = new UseCoupleTypeFix(pairTypeName);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    holder.registerProblem(sourcePsi, string, localQuickFixArray);
                }
                return super.visitDeclaration(node);
            }

            @Nullable
            private static String getPairTypeParameterNameIfBothTheSame(@NotNull UTypeReferenceExpression typeReferenceExpression) {
                PsiClassType classType;
                PsiType[] parameters;
                PsiType type;
                if (typeReferenceExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (PsiTypesUtil.classNameEquals((PsiType)(type = typeReferenceExpression.getType()), (String)PAIR_CLASS_NAME) && (parameters = (classType = (PsiClassType)type).getParameters()).length == 2 && parameters[0].equals(parameters[1])) {
                    return parameters[0].getPresentableText();
                }
                return null;
            }

            private static UTypeReferenceExpression getDeclarationTypeReferenceExpression(@NotNull UDeclaration declaration) {
                if (declaration == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (declaration instanceof UVariable) {
                    UVariable v = (UVariable)declaration;
                    return v.getTypeReference();
                }
                if (declaration instanceof UMethod) {
                    UMethod m = (UMethod)declaration;
                    return m.getReturnTypeReference();
                }
                return null;
            }

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                PsiElement sourcePsi;
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (expression.getKind() == UastCallKind.METHOD_CALL && 1.isPairFactoryMethodWithTheSameArgumentTypes(expression) && (sourcePsi = 1.getMethodCallSourcePsi(expression)) != null) {
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.couple.of", new Object[0]), new LocalQuickFix[]{new ConvertToCoupleFactoryMethodFix()});
                }
                return super.visitCallExpression(expression);
            }

            private static boolean isPairFactoryMethodWithTheSameArgumentTypes(@NotNull UCallExpression methodExpression) {
                String methodName;
                if (methodExpression == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ("create".equals(methodName = methodExpression.getMethodName()) || "pair".equals(methodName)) {
                    PsiMethod method = methodExpression.resolve();
                    if (method == null) {
                        return false;
                    }
                    PsiClass psiClass = method.getContainingClass();
                    if (psiClass != null && PAIR_CLASS_NAME.equals(psiClass.getQualifiedName()) && methodExpression.getValueArgumentCount() == 2) {
                        List arguments = methodExpression.getValueArguments();
                        PsiType type1 = ((UExpression)arguments.get(0)).getExpressionType();
                        if (type1 == null) {
                            return false;
                        }
                        PsiType type2 = ((UExpression)arguments.get(1)).getExpressionType();
                        return Objects.equals(type1, type2);
                    }
                }
                return false;
            }

            @Nullable
            private static PsiElement getMethodCallSourcePsi(UCallExpression expression) {
                UElement parent = expression.getUastParent();
                if (parent instanceof UQualifiedReferenceExpression) {
                    return parent.getSourcePsi();
                }
                return expression.getSourcePsi();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodExpression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getPairTypeParameterNameIfBothTheSame";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDeclarationTypeReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isPairFactoryMethodWithTheSameArgumentTypes";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            UseCoupleInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class UseCoupleTypeFix
    implements LocalQuickFix {
        private final String mySimpleTypeParameterName;

        UseCoupleTypeFix(String simpleTypeParameterName) {
            this.mySimpleTypeParameterName = simpleTypeParameterName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                UseCoupleTypeFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                UseCoupleTypeFix.$$$reportNull$$$0(1);
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            if (element instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)element;
                PsiClassType type1 = (PsiClassType)typeElement.getType();
                PsiType[] parameters = type1.getParameters();
                if (parameters.length != 2) {
                    return;
                }
                PsiTypeElement newType = factory.createTypeElementFromText(COUPLE_CLASS_NAME + "<" + parameters[0].getCanonicalText() + ">", element.getContext());
                PsiElement newElement = element.replace((PsiElement)newType);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
            }
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = DevKitBundle.message("inspections.use.couple.type", this.mySimpleTypeParameterName);
            if (string == null) {
                UseCoupleTypeFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.use.couple.family.name", new Object[0]);
            if (string == null) {
                UseCoupleTypeFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection$UseCoupleTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection$UseCoupleTypeFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ConvertToCoupleFactoryMethodFix
    implements LocalQuickFix {
        private ConvertToCoupleFactoryMethodFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            UCallExpression callExpression;
            if (project == null) {
                ConvertToCoupleFactoryMethodFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ConvertToCoupleFactoryMethodFix.$$$reportNull$$$0(1);
            }
            if ((callExpression = ConvertToCoupleFactoryMethodFix.getUCallExpression(element = descriptor.getPsiElement())) == null) {
                return;
            }
            UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)element.getLanguage());
            if (generationPlugin == null) {
                return;
            }
            UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
            UCallExpression coupleFactoryMethodCall = pluginElementFactory.createCallExpression((UExpression)pluginElementFactory.createQualifiedReference(COUPLE_CLASS_NAME, element), "of", callExpression.getValueArguments(), null, UastCallKind.METHOD_CALL, element);
            if (coupleFactoryMethodCall == null) {
                return;
            }
            generationPlugin.replace((UElement)UastUtils.getQualifiedParentOrThis((UExpression)callExpression), (UElement)coupleFactoryMethodCall, UCallExpression.class);
        }

        @Nullable
        private static UCallExpression getUCallExpression(PsiElement element) {
            UQualifiedReferenceExpression qualifiedReferenceExpression;
            UExpression selector;
            UElement expression = UastContextKt.toUElement((PsiElement)element);
            if (expression instanceof UCallExpression) {
                UCallExpression callExpression = (UCallExpression)expression;
                return callExpression;
            }
            if (expression instanceof UQualifiedReferenceExpression && (selector = (qualifiedReferenceExpression = (UQualifiedReferenceExpression)expression).getSelector()) instanceof UCallExpression) {
                UCallExpression callExpression = (UCallExpression)selector;
                return callExpression;
            }
            return null;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = DevKitBundle.message("inspections.use.couple.of", new Object[0]);
            if (string == null) {
                ConvertToCoupleFactoryMethodFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.use.couple.family.name", new Object[0]);
            if (string == null) {
                ConvertToCoupleFactoryMethodFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection$ConvertToCoupleFactoryMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseCoupleInspection$ConvertToCoupleFactoryMethodFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

