/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.uiDesigner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwHSpacer;
import com.intellij.uiDesigner.lw.LwVSpacer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.uiDesigner.ConvertFormToDslActionKt;
import org.jetbrains.idea.devkit.uiDesigner.FormCall;
import org.jetbrains.idea.devkit.uiDesigner.PropertyBinding;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastVisibility;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0017\u001a\u00020\u0018*\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e*\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/idea/devkit/uiDesigner/FormToDslConverter;", "", "module", "Lcom/intellij/openapi/module/Module;", "boundInstanceUClass", "Lorg/jetbrains/uast/UClass;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/uast/UClass;)V", "convertBinding", "Lorg/jetbrains/idea/devkit/uiDesigner/PropertyBinding;", "binding", "", "convertComponent", "Lorg/jetbrains/idea/devkit/uiDesigner/FormCall;", "component", "Lcom/intellij/uiDesigner/lw/IComponent;", "convertComponentOrContainer", "convertComponentText", "convertContainer", "container", "Lcom/intellij/uiDesigner/lw/LwContainer;", "convertStringDescriptor", "text", "Lcom/intellij/uiDesigner/lw/StringDescriptor;", "appendGridRow", "", "layoutManager", "Lcom/intellij/uiDesigner/core/GridLayoutManager;", "rowIndex", "", "collectComponentsInRow", "", "row", "columnCount", "matchesBinding", "", "Lcom/intellij/psi/PsiNamedElement;", "intellij.devkit.uiDesigner"})
@SourceDebugExtension(value={"SMAP\nConvertFormToDslAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertFormToDslAction.kt\norg/jetbrains/idea/devkit/uiDesigner/FormToDslConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n766#2:483\n857#2,2:484\n1774#2,4:487\n1#3:486\n*S KotlinDebug\n*F\n+ 1 ConvertFormToDslAction.kt\norg/jetbrains/idea/devkit/uiDesigner/FormToDslConverter\n*L\n316#1:483\n316#1:484,2\n429#1:487,4\n*E\n"})
public final class FormToDslConverter {
    @NotNull
    private final Module module;
    @Nullable
    private final UClass boundInstanceUClass;

    public FormToDslConverter(@NotNull Module module, @Nullable UClass boundInstanceUClass) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        this.boundInstanceUClass = boundInstanceUClass;
    }

    @NotNull
    public final FormCall convertContainer(@NotNull LwContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        FormCall row = null;
        StringDescriptor borderTitle = container.getBorderTitle();
        if (borderTitle != null) {
            row = new FormCall("titledRow", null, null, (IComponent)container, null, null, false, 118, null);
            row.getArgs().add(this.convertStringDescriptor(borderTitle));
        } else {
            row = new FormCall("row", null, null, (IComponent)container, null, null, false, 118, null);
        }
        LayoutManager layoutManager = container.getLayout();
        if (layoutManager instanceof GridLayoutManager) {
            int n = ((GridLayoutManager)layoutManager).getRowCount();
            for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
                this.appendGridRow(row, container, (GridLayoutManager)layoutManager, rowIndex);
            }
        } else {
            int n = container.getComponentCount();
            for (int index = 0; index < n; ++index) {
                List<FormCall> list = row.getContents();
                IComponent iComponent = container.getComponent(index);
                Intrinsics.checkNotNullExpressionValue((Object)iComponent, (String)"container.getComponent(index)");
                list.add(this.convertComponentOrContainer(iComponent));
            }
        }
        return row;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendGridRow(FormCall $this$appendGridRow, LwContainer container, GridLayoutManager layoutManager, int rowIndex) {
        void $this$filterTo$iv$iv;
        List<IComponent> allComponents = this.collectComponentsInRow(container, rowIndex, layoutManager.getColumnCount());
        Iterable $this$filter$iv = allComponents;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IComponent it = (IComponent)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof LwHSpacer) && !(it instanceof LwVSpacer))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List components = (List)destination$iv$iv;
        if (components.isEmpty()) {
            return;
        }
        FormCall row = new FormCall("row", null, null, (IComponent)container, null, null, false, 118, null);
        $this$appendGridRow.getContents().add(row);
        if (Intrinsics.areEqual((Object)((IComponent)CollectionsKt.first((List)components)).getComponentClassName(), (Object)"javax.swing.JLabel")) {
            row.getArgs().add(this.convertComponentText((IComponent)CollectionsKt.first((List)components)));
            for (IComponent component : CollectionsKt.drop((Iterable)components, (int)1)) {
                row.getContents().add(this.convertComponentOrContainer(component));
            }
        } else {
            for (IComponent component : components) {
                row.getContents().add(this.convertComponentOrContainer(component));
            }
        }
    }

    private final List<IComponent> collectComponentsInRow(LwContainer $this$collectComponentsInRow, int row, int columnCount) {
        Object[] result = new IComponent[columnCount];
        int n = $this$collectComponentsInRow.getComponentCount();
        for (int i = 0; i < n; ++i) {
            IComponent component = $this$collectComponentsInRow.getComponent(i);
            GridConstraints constraints = component.getConstraints();
            if (constraints.getRow() != row) continue;
            result[constraints.getColumn()] = component;
        }
        return CollectionsKt.filterNotNull((Iterable)ArraysKt.toList((Object[])result));
    }

    private final FormCall convertComponentOrContainer(IComponent component) {
        if (component instanceof LwContainer) {
            return this.convertContainer((LwContainer)component);
        }
        FormCall result = this.convertComponent(component);
        result.setOrigin(component);
        result.setBinding(component.getBinding());
        result.setBindingType(component.getComponentClassName());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final FormCall convertComponent(IComponent component) {
        FormCall formCall;
        PropertyBinding propertyBinding = this.convertBinding(component.getBinding());
        String string = component.getComponentClassName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 938465551: {
                    if (!string.equals("com.intellij.openapi.ui.ComboBox")) break;
                    n = 1;
                    break;
                }
                case 1098956259: {
                    if (!string.equals("com.intellij.ui.components.JBCheckBox")) break;
                    n = 2;
                    break;
                }
                case -726189100: {
                    if (!string.equals("javax.swing.JButton")) break;
                    n = 3;
                    break;
                }
                case -1221677077: {
                    if (!string.equals("javax.swing.JTextField")) break;
                    n = 4;
                    break;
                }
                case 400838162: {
                    if (!string.equals("javax.swing.JLabel")) break;
                    n = 5;
                    break;
                }
                case 561846213: {
                    if (!string.equals("javax.swing.JCheckBox")) break;
                    n = 2;
                    break;
                }
                case 1596308685: {
                    if (!string.equals("com.intellij.ui.components.JBRadioButton")) break;
                    n = 6;
                    break;
                }
                case -256449859: {
                    if (!string.equals("com.intellij.openapi.ui.TextFieldWithBrowseButton")) break;
                    n = 7;
                    break;
                }
                case -1587333761: {
                    if (!string.equals("javax.swing.JComboBox")) break;
                    n = 1;
                    break;
                }
                case -1204187980: {
                    if (!string.equals("com.intellij.ui.components.JBLabel")) break;
                    n = 5;
                    break;
                }
                case -695894101: {
                    if (!string.equals("javax.swing.JRadioButton")) break;
                    n = 6;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    String[] stringArray = new String[]{this.convertComponentText(component)};
                    PropertyBinding propertyBinding2 = propertyBinding;
                    formCall = new FormCall("checkBox", stringArray).addArgIfPresent((String[])(propertyBinding2 != null ? propertyBinding2.getBindingCallParameters() : null));
                    return formCall;
                }
                case 4: {
                    PropertyBinding propertyBinding3 = propertyBinding;
                    String methodName = Intrinsics.areEqual((Object)(propertyBinding3 != null && (propertyBinding3 = propertyBinding3.getType()) != null ? propertyBinding3.getCanonicalText() : null), (Object)"int") ? "intTextField" : "textField";
                    PropertyBinding propertyBinding4 = propertyBinding;
                    String[] stringArray = new String[]{"{ \"\" }", "{}"};
                    formCall = new FormCall(methodName, null, null, null, null, null, false, 126, null).addArgOrDefault((String[])(propertyBinding4 != null ? propertyBinding4.getBindingCallParameters() : null), stringArray);
                    return formCall;
                }
                case 7: {
                    PropertyBinding propertyBinding5 = propertyBinding;
                    String[] methodName = new String[]{"{ \"\" }", "{}"};
                    formCall = new FormCall("textFieldWithBrowseButton", null, null, null, null, null, false, 126, null).addArgOrDefault((String[])(propertyBinding5 != null ? propertyBinding5.getBindingCallParameters() : null), methodName);
                    return formCall;
                }
                case 6: {
                    String[] methodName = new String[]{this.convertComponentText(component)};
                    FormCall formCall2 = new FormCall("radioButton", methodName);
                    formCall = formCall2;
                    return formCall;
                }
                case 3: {
                    String[] methodName = new String[]{this.convertComponentText(component), "actionListener = { TODO() }"};
                    FormCall formCall3 = new FormCall("button", methodName);
                    formCall = formCall3;
                    return formCall;
                }
                case 5: {
                    String[] methodName = new String[]{this.convertComponentText(component)};
                    FormCall formCall4 = new FormCall("label", methodName);
                    formCall = formCall4;
                    return formCall;
                }
                case 1: {
                    String[] methodName = new String[]{"TODO()"};
                    FormCall formCall5 = new FormCall("comboBox", methodName);
                    formCall = formCall5;
                    return formCall;
                }
            }
        }
        String string2 = component.getComponentClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"component.componentClassName");
        String typeParameters = ConvertFormToDslActionKt.access$buildTypeParametersString(this.module, string2);
        String string3 = component.getComponentClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"component.componentClassName");
        String classShortName = StringsKt.substringAfterLast$default((String)string3, (char)'.', null, (int)2, null);
        formCall = new FormCall(classShortName + typeParameters + "()", null, null, null, null, null, true, 62, null);
        return formCall;
    }

    private final PropertyBinding convertBinding(String binding) {
        UMethod setter;
        UMethod getter;
        Object[] objectArray;
        block8: {
            UMethod uMethod;
            UMethod uMethod2;
            int n;
            block7: {
                UField field;
                int n2;
                block6: {
                    UField uField;
                    if (binding == null || this.boundInstanceUClass == null) {
                        return null;
                    }
                    UField[] uFieldArray = this.boundInstanceUClass.getFields();
                    n2 = uFieldArray.length;
                    for (int i = 0; i < n2; ++i) {
                        UField uField2;
                        UField it = uField2 = uFieldArray[i];
                        boolean bl = false;
                        if (!this.matchesBinding((PsiNamedElement)it, binding)) continue;
                        uField = uField2;
                        break block6;
                    }
                    uField = field = null;
                }
                if (field != null && !field.isStatic() && field.getVisibility() != UastVisibility.PRIVATE) {
                    String[] stringArray = new String[]{"model::" + field.getName()};
                    return new PropertyBinding(field.getType(), stringArray);
                }
                objectArray = this.boundInstanceUClass.getMethods();
                n = objectArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    UMethod uMethod3;
                    UMethod it = uMethod3 = objectArray[n2];
                    boolean bl = false;
                    if (!(!StringsKt.startsWith$default((String)it.getName(), (String)"set", (boolean)false, (int)2, null) && this.matchesBinding((PsiNamedElement)it, binding))) continue;
                    uMethod2 = uMethod3;
                    break block7;
                }
                uMethod2 = null;
            }
            getter = uMethod2;
            UMethod[] uMethodArray = this.boundInstanceUClass.getMethods();
            int n3 = uMethodArray.length;
            for (n = 0; n < n3; ++n) {
                UMethod uMethod4;
                UMethod it = uMethod4 = uMethodArray[n];
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getName(), (String)"set", (boolean)false, (int)2, null) && this.matchesBinding((PsiNamedElement)it, binding))) continue;
                uMethod = uMethod4;
                break block8;
            }
            uMethod = setter = null;
        }
        if (getter != null && setter != null) {
            objectArray = new String[]{"model::" + getter.getName(), "model::" + setter.getName()};
            return new PropertyBinding(getter.getReturnType(), (String[])objectArray);
        }
        return null;
    }

    private final boolean matchesBinding(PsiNamedElement $this$matchesBinding, String binding) {
        int n;
        List list = NameUtil.nameToWordsLowerCase((String)StringsKt.removePrefix((String)binding, (CharSequence)"my"));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"nameToWordsLowerCase(binding.removePrefix(\"my\"))");
        List bindingWords = list;
        String string = $this$matchesBinding.getName();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"my")) == null) {
            string = "";
        }
        List list2 = NameUtil.nameToWordsLowerCase((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"nameToWordsLowerCase(nam\u2026removePrefix(\"my\") ?: \"\")");
        List elementWords = list2;
        if (bindingWords.size() == 1 && elementWords.size() == 1) {
            return Intrinsics.areEqual(bindingWords.get(0), elementWords.get(0));
        }
        Iterable $this$count$iv = bindingWords;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!elementWords.contains(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > 1;
    }

    private final String convertComponentText(IComponent component) {
        Object object = ConvertFormToDslActionKt.access$getPropertyValue(component, "text");
        if (object == null) {
            return "";
        }
        Object propertyValue = object;
        return this.convertStringDescriptor((StringDescriptor)propertyValue);
    }

    private final String convertStringDescriptor(StringDescriptor text) {
        String string = text.getValue();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return "\"" + StringUtil.escapeQuotes((String)it) + "\"";
        }
        String string2 = text.getBundleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text.bundleName");
        return StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null) + ".message(\"" + text.getKey() + "\")";
    }
}

