/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterCheckerData;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0081\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u001a\u001a\u00020\u0016*\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0004J\u0014\u0010\u001e\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0016H\u0004J\u0014\u0010 \u001a\u00020\u001b*\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0014\u0010\"\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "canBeInterpreted", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "interpret", "failAsError", "reportIfError", "original", "warningIfError", "Data", "ir.interpreter"})
public abstract class IrConstTransformer
implements IrElementTransformer<Data> {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @NotNull
    private final IrInterpreterChecker checker;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onError;
    private final boolean suppressExceptions;

    public IrConstTransformer(@NotNull IrInterpreter interpreter, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.interpreter = interpreter;
        this.irFile = irFile;
        this.mode = mode;
        this.checker = checker;
        this.evaluatedConstTracker = evaluatedConstTracker;
        this.inlineConstTracker = inlineConstTracker;
        this.onWarning = onWarning;
        this.onError = onError;
        this.suppressExceptions = suppressExceptions;
    }

    @NotNull
    protected final IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke((Object)this.irFile, (Object)original, (Object)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke((Object)this.irFile, (Object)original, (Object)$this$reportIfError);
            return WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()] == 1 ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    protected final boolean canBeInterpreted(@NotNull IrExpression $this$canBeInterpreted, @NotNull IrInterpreterConfiguration configuration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canBeInterpreted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        try {
            bl = (Boolean)$this$canBeInterpreted.accept(this.checker, new IrInterpreterCheckerData(this.mode, this.interpreter.getIrBuiltIns(), configuration));
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return false;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$canBeInterpreted, null, 1, null), e);
        }
        return bl;
    }

    public static /* synthetic */ boolean canBeInterpreted$default(IrConstTransformer irConstTransformer, IrExpression irExpression, IrInterpreterConfiguration irInterpreterConfiguration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canBeInterpreted");
        }
        if ((n & 1) != 0) {
            irInterpreterConfiguration = irConstTransformer.interpreter.getEnvironment$ir_interpreter().getConfiguration();
        }
        return irConstTransformer.canBeInterpreted(irExpression, irInterpreterConfiguration);
    }

    @NotNull
    protected final IrExpression interpret(@NotNull IrExpression $this$interpret, boolean failAsError) {
        IrExpression result2;
        block12: {
            IrField field2;
            IrField irField;
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)$this$interpret, (String)"<this>");
            try {
                irExpression = this.interpreter.interpret($this$interpret, this.irFile);
            }
            catch (Throwable e) {
                if (this.suppressExceptions) {
                    return $this$interpret;
                }
                throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$interpret, null, 1, null), e);
            }
            result2 = irExpression;
            EvaluatedConstTracker evaluatedConstTracker = this.evaluatedConstTracker;
            if (evaluatedConstTracker != null) {
                ConstantValue<?> constantValue;
                int n = result2.getStartOffset();
                int n2 = result2.getEndOffset();
                String string = IrDeclarationsKt.getNameWithPackage(this.irFile);
                if (result2 instanceof IrErrorExpression) {
                    constantValue = (ConstantValue<?>)ErrorValue.Companion.create(((IrErrorExpression)result2).getDescription());
                } else {
                    Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
                    constantValue = IrTreeBuildUtilsKt.toConstantValue((IrConst)result2);
                }
                evaluatedConstTracker.save(n, n2, string, constantValue);
            }
            if (!(result2 instanceof IrConst)) break block12;
            IrExpression irExpression2 = $this$interpret;
            if (irExpression2 instanceof IrGetField) {
                irField = (IrField)((IrGetField)$this$interpret).getSymbol().getOwner();
            } else if (irExpression2 instanceof IrCall) {
                IrProperty irProperty = UtilsKt.getProperty(((IrCall)$this$interpret).getSymbol().getOwner());
                irField = irProperty != null ? irProperty.getBackingField() : null;
            } else {
                irField = field2 = null;
            }
            if (field2 != null) {
                InlineConstTracker inlineConstTracker = this.inlineConstTracker;
                if (inlineConstTracker != null) {
                    IrConstTransformerKt.reportOnIr(inlineConstTracker, this.irFile, field2, (IrConst)result2);
                }
            }
        }
        return failAsError ? this.reportIfError(result2, $this$interpret) : this.warningIfError(result2, $this$interpret);
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression, data);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression, data);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhen(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "", "inAnnotation", "", "(Z)V", "getInAnnotation", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    public static final class Data {
        private final boolean inAnnotation;

        public Data(boolean inAnnotation) {
            this.inAnnotation = inAnnotation;
        }

        public /* synthetic */ Data(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getInAnnotation() {
            return this.inAnnotation;
        }

        public final boolean component1() {
            return this.inAnnotation;
        }

        @NotNull
        public final Data copy(boolean inAnnotation) {
            return new Data(inAnnotation);
        }

        public static /* synthetic */ Data copy$default(Data data, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = data.inAnnotation;
            }
            return data.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Data(inAnnotation=" + this.inAnnotation + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.inAnnotation);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.inAnnotation == data.inAnnotation;
        }

        public Data() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EvaluationMode.values().length];
            try {
                nArray[EvaluationMode.ONLY_INTRINSIC_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

