/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.offline;

import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class ClassLengthAnalyser
extends ClassVisitor {
    private int myMaxLine = -1;
    private int myHits = 0;

    public ClassLengthAnalyser() {
        super(589824);
    }

    public int getHits() {
        return this.myHits;
    }

    public int getMaxLine() {
        return this.myMaxLine;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodVisitor(589824, mv){

            public void visitJumpInsn(int opcode, Label label) {
                super.visitJumpInsn(opcode, label);
                ClassLengthAnalyser.this.myHits = ClassLengthAnalyser.this.myHits + 2;
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                super.visitTableSwitchInsn(min, max, dflt, labels);
                ClassLengthAnalyser.this.myHits = ClassLengthAnalyser.this.myHits + (1 + labels.length);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                super.visitLookupSwitchInsn(dflt, keys, labels);
                ClassLengthAnalyser.this.myHits = ClassLengthAnalyser.this.myHits + (1 + labels.length);
            }

            public void visitLineNumber(int line, Label start) {
                super.visitLineNumber(line, start);
                if (line > ClassLengthAnalyser.this.myMaxLine) {
                    ClassLengthAnalyser.this.myMaxLine = line;
                }
                ClassLengthAnalyser.this.myHits++;
            }
        };
    }
}

