/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSAEncoder {
    private final BigInteger privateExponent;
    private final BigInteger privateModulus;
    private final int chunkSize;
    private final int digitsPerChunk;
    private int digitsGenerated = 0;
    private final BigInteger myDigitsMod;
    private final boolean myAddDashes;

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus) {
        this(privateExponent, privateModulus, 16, true);
    }

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.privateExponent = privateExponent;
        this.privateModulus = privateModulus;
        this.myAddDashes = addDashes;
        int keyLength = privateModulus.bitLength();
        this.myDigitsMod = new BigInteger(String.valueOf(alphabetSize));
        int digits = (int)Math.ceil((double)keyLength / Math.log(alphabetSize) * Math.log(2.0));
        if (digits % 5 != 0) {
            digits = (digits / 5 + 1) * 5;
        }
        this.digitsPerChunk = digits;
        this.chunkSize = keyLength / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] original;
        int leap = data.length % this.chunkSize;
        if (leap == 0) {
            original = data;
        } else {
            original = new byte[data.length + this.chunkSize - leap];
            System.arraycopy(data, 0, original, this.chunkSize - leap, data.length);
        }
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < original.length; i += this.chunkSize) {
            this.encodeChunk(original, encoded, i, this.chunkSize);
        }
        return encoded.toString();
    }

    public String encodeString(String data) {
        try {
            return this.encode(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private void encodeChunk(byte[] original, StringBuilder encoded, int offset, int len) {
        if (len == 0) {
            return;
        }
        byte[] buf = new byte[this.chunkSize];
        System.arraycopy(original, offset, buf, 0, len);
        BigInteger chunk = new BigInteger(1, buf);
        if (chunk.compareTo(this.privateModulus) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger encodedChunk = chunk.modPow(this.privateExponent, this.privateModulus);
        this.appendFormatted(encoded, this.encode(encodedChunk));
    }

    private void appendFormatted(StringBuilder result, CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            this.appendSeparator(result);
            result.append(s.charAt(i));
        }
    }

    private CharSequence encode(BigInteger value) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.digitsPerChunk; ++i) {
            buf.append(RSAEncoder.digitChar(value.mod(this.myDigitsMod)));
            value = value.divide(this.myDigitsMod);
        }
        return new ReverseCharSequence(buf);
    }

    private void appendSeparator(StringBuilder buf) {
        if (this.digitsGenerated > 0 && this.digitsGenerated % 5 == 0) {
            if (this.digitsGenerated % 30 == 0) {
                buf.append('\n');
            } else if (this.myAddDashes) {
                buf.append('-');
            }
        }
        ++this.digitsGenerated;
    }

    private static char digitChar(BigInteger digit) {
        int d = digit.intValue();
        char c = d < 10 ? (char)(48 + d) : (d < 36 ? (char)(65 + d - 10) : (d < 62 ? (char)(97 + d - 36) : (char)(33 + d - 62)));
        return c;
    }

    public String encodeProperties(Map<String, String> properties) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.indexOf(10) >= 0 || value.indexOf(10) >= 0) {
                throw new RuntimeException("Keys and values are not allowed to contain linefeeds");
            }
            buf.append(key).append('\n').append(value).append('\n');
        }
        return this.encodeString(buf.toString());
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence mySequence;

        public ReverseCharSequence(CharSequence sequence) {
            this.mySequence = sequence;
        }

        public int length() {
            return this.mySequence.length();
        }

        public char charAt(int index) {
            return this.mySequence.charAt(this.mySequence.length() - index - 1);
        }

        public CharSequence subSequence(int start, int end) {
            int length = this.mySequence.length();
            return new ReverseCharSequence(this.mySequence.subSequence(length - end, length - start));
        }
    }
}

