/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.usethesource.capsule.core.trie;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.gradle.internal.impldep.io.usethesource.capsule.core.trie.Node;

public class BottomUpTransientNodeTransformer<SN extends Node, DN extends Node> {
    private static final int MAX_DEPTH = 7;
    private final BiFunction<SN, AtomicReference<Thread>, DN> nodeMapper;
    private final AtomicReference<Thread> mutator;
    private final DN dstRootNode;
    private int stackIndex = -1;
    private final ListIterator<SN>[] srcIteratorStack = new ListIterator[7];
    private final ListIterator<DN>[] dstIteratorStack = new ListIterator[7];

    public BottomUpTransientNodeTransformer(SN srcRootNode, BiFunction<SN, AtomicReference<Thread>, DN> nodeMapper) {
        this.nodeMapper = nodeMapper;
        this.mutator = new AtomicReference<Thread>(Thread.currentThread());
        this.dstRootNode = (Node)nodeMapper.apply(srcRootNode, this.mutator);
        Iterator srcIterator = srcRootNode.nodeArray().iterator();
        if (srcIterator.hasNext()) {
            Iterator dstIterator = this.dstRootNode.nodeArray().iterator();
            this.pushOnStack((ListIterator<SN>)srcIterator, (ListIterator<DN>)dstIterator);
        }
    }

    public final DN apply() {
        if (!this.isStackEmpty()) {
            this.processStack();
        }
        this.mutator.set(null);
        return this.dstRootNode;
    }

    private final boolean isStackEmpty() {
        return this.stackIndex == -1;
    }

    private final void pushOnStack(ListIterator<SN> srcNode, ListIterator<DN> dstNode) {
        int nextIndex = ++this.stackIndex;
        this.srcIteratorStack[nextIndex] = srcNode;
        this.dstIteratorStack[nextIndex] = dstNode;
    }

    private final void dropFromStack() {
        int previousIndex = this.stackIndex--;
        this.srcIteratorStack[previousIndex] = null;
        this.dstIteratorStack[previousIndex] = null;
    }

    private final void processStack() {
        while (!this.isStackEmpty()) {
            ListIterator<SN> srcIterator = this.srcIteratorStack[this.stackIndex];
            ListIterator<DN> dstIterator = this.dstIteratorStack[this.stackIndex];
            boolean stackModified = false;
            while (!stackModified) {
                if (srcIterator.hasNext()) {
                    Node src = (Node)srcIterator.next();
                    Node dst = (Node)this.nodeMapper.apply(src, this.mutator);
                    dstIterator.next();
                    dstIterator.set(dst);
                    Iterator nextSrcIterator = src.nodeArray().iterator();
                    if (!nextSrcIterator.hasNext()) continue;
                    Iterator nextDstIterator = dst.nodeArray().iterator();
                    this.pushOnStack((ListIterator<SN>)nextSrcIterator, (ListIterator<DN>)nextDstIterator);
                    stackModified = true;
                    continue;
                }
                this.dropFromStack();
                stackModified = true;
            }
        }
    }
}

