/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.DefaultChangeListOwner;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangesViewDnDSupport
extends ChangesTreeDnDSupport {
    @NotNull
    private final Project myProject;

    public static void install(@NotNull Project project2, @NotNull ChangesTree tree2, @NotNull Disposable disposable) {
        if (project2 == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(0);
        }
        if (tree2 == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(2);
        }
        new ChangesViewDnDSupport(project2, tree2).install(disposable);
    }

    private ChangesViewDnDSupport(@NotNull Project project2, @NotNull ChangesTree tree2) {
        if (project2 == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(3);
        }
        if (tree2 == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(4);
        }
        super(tree2);
        this.myProject = project2;
    }

    @Override
    @Nullable
    protected DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
        if (info == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(5);
        }
        if (info.isMove()) {
            List changes = VcsTreeModelData.selected((JTree)((Object)this.myTree)).iterateUserObjects(Change.class).toList();
            List unversionedFiles = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myTree), ChangesBrowserNode.UNVERSIONED_FILES_TAG).iterateUserObjects(FilePath.class).toList();
            List ignoredFiles = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myTree), ChangesBrowserNode.IGNORED_FILES_TAG).iterateUserObjects(FilePath.class).toList();
            if (!(changes.isEmpty() && unversionedFiles.isEmpty() && ignoredFiles.isEmpty())) {
                return new DnDDragStartBean((Object)new ChangeListDragBean((JComponent)((Object)this.myTree), changes, unversionedFiles, ignoredFiles));
            }
        }
        return null;
    }

    @Override
    protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @Nullable ChangesBrowserNode<?> dropNode) {
        Object attached;
        if (aEvent == null) {
            ChangesViewDnDSupport.$$$reportNull$$$0(6);
        }
        if ((attached = aEvent.getAttachedObject()) instanceof ChangeListDragBean) {
            if (dropNode != null) {
                ChangeListDragBean dragBean = (ChangeListDragBean)attached;
                dragBean.setTargetNode(dropNode);
                return dragBean.getSourceComponent() == this.myTree && dropNode.canAcceptDrop(dragBean);
            }
        } else if (attached instanceof ShelvedChangeListDragBean) {
            return dropNode == null || dropNode instanceof ChangesBrowserChangeListNode;
        }
        return false;
    }

    public void drop(DnDEvent aEvent) {
        ChangeListDragBean dragBean;
        ChangesBrowserNode changesBrowserNode;
        Object attached = aEvent.getAttachedObject();
        if (attached instanceof ShelvedChangeListDragBean) {
            LocalChangeList targetChangeList;
            ShelvedChangeListDragBean dragBean2 = (ShelvedChangeListDragBean)attached;
            ChangesBrowserNode<?> dropRootNode = ChangesViewDnDSupport.getDropRootNode(this.myTree, aEvent);
            if (dropRootNode != null) {
                targetChangeList = (LocalChangeList)TreeUtil.getUserObject(LocalChangeList.class, dropRootNode);
            } else {
                ShelvedChangeList changeList = (ShelvedChangeList)ContainerUtil.getFirstItem(dragBean2.getShelvedChangelists());
                String suggestedName = changeList != null ? changeList.getName() : VcsBundle.message("changes.new.changelist", new Object[0]);
                String listName = ChangeListUtil.createNameForChangeList(this.myProject, suggestedName);
                targetChangeList = ChangeListManager.getInstance(this.myProject).addChangeList(listName, null);
            }
            ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, dragBean2, targetChangeList, !ChangesViewDnDSupport.isCopyAction(aEvent));
        } else if (attached instanceof ChangeListDragBean && (changesBrowserNode = (dragBean = (ChangeListDragBean)attached).getTargetNode()) != null) {
            changesBrowserNode.acceptDrop(new DefaultChangeListOwner(this.myProject), dragBean);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aEvent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesViewDnDSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createDragStartBean";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandleDropEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

