/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTreeModelData {
    @NotNull
    public static VcsTreeModelData all(@NotNull JTree tree2) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(0);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        return new AllUnderData(VcsTreeModelData.getRoot(tree2));
    }

    @NotNull
    public static VcsTreeModelData selected(@NotNull JTree tree2) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(1);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedData(tree2);
    }

    @NotNull
    public static VcsTreeModelData exactlySelected(@NotNull JTree tree2) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(2);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        return new ExactlySelectedData(tree2);
    }

    @NotNull
    public static VcsTreeModelData included(@NotNull ChangesTree tree2) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(3);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        return new IncludedUnderData(tree2, VcsTreeModelData.getRoot((JTree)((Object)tree2)));
    }

    @Deprecated
    @NotNull
    public static VcsTreeModelData children(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            VcsTreeModelData.$$$reportNull$$$0(4);
        }
        return VcsTreeModelData.allUnder(node);
    }

    @NotNull
    public static VcsTreeModelData allUnderTag(@NotNull JTree tree2, @NotNull Object tag) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(5);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(6);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode(tree2, tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new AllUnderData(tagNode);
    }

    @NotNull
    public static VcsTreeModelData allUnder(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            VcsTreeModelData.$$$reportNull$$$0(7);
        }
        return new AllUnderData(node);
    }

    @NotNull
    public static VcsTreeModelData selectedUnderTag(@NotNull JTree tree2, @NotNull Object tag) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(8);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(9);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedTagData(tree2, tag);
    }

    @NotNull
    public static VcsTreeModelData includedUnderTag(@NotNull ChangesTree tree2, @NotNull Object tag) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(10);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(11);
        }
        assert (tree2.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode((JTree)((Object)tree2), tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new IncludedUnderData(tree2, tagNode);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final Stream<ChangesBrowserNode<?>> rawNodesStream() {
        Stream stream = this.iterateRawNodes().toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @Deprecated
    @NotNull
    public final Stream<ChangesBrowserNode<?>> nodesStream() {
        Stream stream = this.iterateNodes().toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final Stream<Object> rawUserObjectsStream() {
        Stream stream = this.iterateRawUserObjects().toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final <U> Stream<U> rawUserObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(15);
        }
        Stream stream = this.iterateRawUserObjects(clazz).toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(16);
        }
        return stream;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final Stream<Object> userObjectsStream() {
        Stream stream = this.iterateUserObjects().toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @Deprecated
    @NotNull
    public final <U> Stream<U> userObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(18);
        }
        Stream stream = this.iterateUserObjects(clazz).toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(19);
        }
        return stream;
    }

    @NotNull
    public abstract JBIterable<ChangesBrowserNode<?>> iterateRawNodes();

    @NotNull
    public final JBIterable<ChangesBrowserNode<?>> iterateNodes() {
        JBIterable jBIterable = this.iterateRawNodes().filter(ChangesBrowserNode::isMeaningfulNode);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<Object> iterateRawUserObjects() {
        JBIterable jBIterable = this.iterateRawNodes().map(ChangesBrowserNode::getUserObject);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @NotNull
    public final <U> JBIterable<U> iterateRawUserObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(22);
        }
        JBIterable jBIterable = this.iterateRawNodes().map(ChangesBrowserNode::getUserObject).filter(clazz);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<Object> iterateUserObjects() {
        JBIterable jBIterable = this.iterateNodes().map(ChangesBrowserNode::getUserObject);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(24);
        }
        return jBIterable;
    }

    @NotNull
    public final <U> JBIterable<U> iterateUserObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(25);
        }
        JBIterable jBIterable = this.iterateNodes().map(ChangesBrowserNode::getUserObject).filter(clazz);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    public final List<Object> userObjects() {
        List list = this.iterateUserObjects().toList();
        if (list == null) {
            VcsTreeModelData.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public final <U> List<U> userObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(28);
        }
        List list = this.iterateUserObjects(clazz).toList();
        if (list == null) {
            VcsTreeModelData.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public static ListSelection<Object> getListSelectionOrAll(@NotNull JTree tree2) {
        List<Object> entries2;
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(30);
        }
        if ((entries2 = VcsTreeModelData.selected(tree2).userObjects()).size() > 1) {
            ListSelection listSelection = ListSelection.createAt(entries2, (int)0).asExplicitSelection();
            if (listSelection == null) {
                VcsTreeModelData.$$$reportNull$$$0(31);
            }
            return listSelection;
        }
        ChangesBrowserNode selected = (ChangesBrowserNode)VcsTreeModelData.selected(tree2).iterateNodes().first();
        List<Object> allEntries = VcsTreeModelData.underExpandByDefault(selected) ? new AllExpandedByDefaultData(VcsTreeModelData.getRoot(tree2)).userObjects() : VcsTreeModelData.all(tree2).userObjects();
        if (allEntries.size() <= entries2.size()) {
            ListSelection listSelection = ListSelection.createAt(entries2, (int)0).asExplicitSelection();
            if (listSelection == null) {
                VcsTreeModelData.$$$reportNull$$$0(32);
            }
            return listSelection;
        }
        int index = selected != null ? ContainerUtil.indexOfIdentity(allEntries, selected.getUserObject()) : 0;
        ListSelection listSelection = ListSelection.createAt(allEntries, (int)index);
        if (listSelection == null) {
            VcsTreeModelData.$$$reportNull$$$0(33);
        }
        return listSelection;
    }

    @Nullable
    public static Object getData(@Nullable Project project2, @NotNull JTree tree2, @NotNull String dataId) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(34);
        }
        if (dataId == null) {
            VcsTreeModelData.$$$reportNull$$$0(35);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return project2;
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            Change[] changes = (Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree2)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
            if (changes.length != 0) {
                return changes;
            }
            return VcsTreeModelData.mapToChange(VcsTreeModelData.all(tree2)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsDataKeys.SELECTED_CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree2)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
        }
        if (VcsDataKeys.CHANGES_SELECTION.is(dataId)) {
            return VcsTreeModelData.getListSelectionOrAll(tree2).map(entry2 -> (Change)ObjectUtils.tryCast((Object)entry2, Change.class));
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.exactlySelected(tree2)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            VcsTreeModelData treeSelection = VcsTreeModelData.selected(tree2);
            VcsTreeModelData exactSelection = VcsTreeModelData.exactlySelected(tree2);
            return slowId -> VcsTreeModelData.getSlowData(project2, treeSelection, exactSelection, slowId);
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@Nullable Project project2, @NotNull VcsTreeModelData treeSelection, @NotNull VcsTreeModelData exactSelection, @NotNull String slowId) {
        if (treeSelection == null) {
            VcsTreeModelData.$$$reportNull$$$0(36);
        }
        if (exactSelection == null) {
            VcsTreeModelData.$$$reportNull$$$0(37);
        }
        if (slowId == null) {
            VcsTreeModelData.$$$reportNull$$$0(38);
        }
        if (SelectInContext.DATA_KEY.is(slowId)) {
            if (project2 == null) {
                return null;
            }
            VirtualFile file = (VirtualFile)VcsTreeModelData.mapObjectToVirtualFile(exactSelection.iterateRawUserObjects()).first();
            if (file == null) {
                return null;
            }
            return new FileSelectInContext(project2, file, null);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(slowId)) {
            return VcsTreeModelData.mapToVirtualFile(treeSelection).toArray((Object[])VirtualFile.EMPTY_ARRAY);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(slowId)) {
            if (project2 == null) {
                return null;
            }
            return ChangesUtil.getNavigatableArray(project2, VcsTreeModelData.mapToNavigatableFile(treeSelection));
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(slowId)) {
            return VcsTreeModelData.mapToIoFile(treeSelection).toArray((Object[])ArrayUtil.EMPTY_FILE_ARRAY);
        }
        return null;
    }

    @NotNull
    private static JBIterable<Change> mapToChange(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(39);
        }
        JBIterable jBIterable = data2.iterateUserObjects().filter(Change.class);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(40);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<VirtualFile> mapToNavigatableFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(41);
        }
        JBIterable jBIterable = data2.iterateUserObjects().flatMap(entry2 -> {
            if (entry2 instanceof Change) {
                return ChangesUtil.iteratePathsCaseSensitive((Change)entry2).map(FilePath::getVirtualFile);
            }
            if (entry2 instanceof VirtualFile) {
                return JBIterable.of((Object)((VirtualFile)entry2));
            }
            if (entry2 instanceof FilePath) {
                return JBIterable.of((Object)((FilePath)entry2).getVirtualFile());
            }
            return JBIterable.empty();
        }).filterNotNull().filter(VirtualFile::isValid);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(42);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<VirtualFile> mapToVirtualFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(43);
        }
        return VcsTreeModelData.mapObjectToVirtualFile(data2.iterateUserObjects());
    }

    @NotNull
    static JBIterable<VirtualFile> mapObjectToVirtualFile(@NotNull JBIterable<Object> userObjects) {
        if (userObjects == null) {
            VcsTreeModelData.$$$reportNull$$$0(44);
        }
        JBIterable jBIterable = userObjects.map(entry2 -> {
            if (entry2 instanceof Change) {
                FilePath path2 = ChangesUtil.getAfterPath((Change)entry2);
                return path2 != null ? path2.getVirtualFile() : null;
            }
            if (entry2 instanceof VirtualFile) {
                return (VirtualFile)entry2;
            }
            if (entry2 instanceof FilePath) {
                return ((FilePath)entry2).getVirtualFile();
            }
            return null;
        }).filterNotNull().filter(VirtualFile::isValid);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(45);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<File> mapToIoFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(46);
        }
        JBIterable jBIterable = data2.iterateUserObjects().map(entry2 -> {
            if (entry2 instanceof Change) {
                FilePath path2 = ChangesUtil.getAfterPath((Change)entry2);
                return path2 != null ? path2.getIOFile() : null;
            }
            return null;
        }).filterNotNull();
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(47);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<FilePath> mapToFilePath(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(48);
        }
        JBIterable jBIterable = data2.iterateUserObjects().map(entry2 -> {
            if (entry2 instanceof Change) {
                return ChangesUtil.getFilePath((Change)entry2);
            }
            if (entry2 instanceof VirtualFile) {
                return VcsUtil.getFilePath((VirtualFile)entry2);
            }
            if (entry2 instanceof FilePath) {
                return (FilePath)entry2;
            }
            return null;
        }).filterNotNull();
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(49);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<VirtualFile> mapToExactVirtualFile(@NotNull VcsTreeModelData data2) {
        if (data2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(50);
        }
        JBIterable jBIterable = data2.iterateUserObjects().map(object -> {
            if (object instanceof VirtualFile) {
                return (VirtualFile)object;
            }
            if (object instanceof FilePath) {
                return ((FilePath)object).getVirtualFile();
            }
            return null;
        }).filterNotNull().filter(VirtualFile::isValid);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(51);
        }
        return jBIterable;
    }

    @Nullable
    public static ChangesBrowserNode<?> findTagNode(@NotNull JTree tree2, @NotNull Object tag) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(52);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(53);
        }
        ChangesBrowserNode root = (ChangesBrowserNode)tree2.getModel().getRoot();
        return (ChangesBrowserNode)root.iterateNodeChildren().find(node -> tag.equals(node.getUserObject()));
    }

    private static boolean underExpandByDefault(@Nullable ChangesBrowserNode<?> node) {
        while (node != null) {
            if (!node.shouldExpandByDefault()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    @NotNull
    private static ChangesBrowserNode<?> getRoot(@NotNull JTree tree2) {
        if (tree2 == null) {
            VcsTreeModelData.$$$reportNull$$$0(54);
        }
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)tree2.getModel().getRoot();
        if (changesBrowserNode == null) {
            VcsTreeModelData.$$$reportNull$$$0(55);
        }
        return changesBrowserNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 16, 17, 19, 20, 21, 23, 24, 26, 27, 29, 31, 32, 33, 40, 42, 45, 47, 49, 51, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeSelection";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exactSelection";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slowId";
                break;
            }
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rawNodesStream";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesStream";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "rawUserObjectsStream";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjectsStream";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNodes";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateRawUserObjects";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateUserObjects";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjects";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionOrAll";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToChange";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToNavigatableFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "mapObjectToVirtualFile";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToIoFile";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToFilePath";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToExactVirtualFile";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exactlySelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "included";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allUnderTag";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "allUnder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectedUnderTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "includedUnderTag";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 55: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rawUserObjectsStream";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "userObjectsStream";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "iterateRawUserObjects";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "iterateUserObjects";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "userObjects";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getListSelectionOrAll";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getSlowData";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "mapToChange";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "mapToNavigatableFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "mapToVirtualFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mapObjectToVirtualFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "mapToIoFile";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "mapToFilePath";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "mapToExactVirtualFile";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findTagNode";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 13, 14, 16, 17, 19, 20, 21, 23, 24, 26, 27, 29, 31, 32, 33, 40, 42, 45, 47, 49, 51, 55 -> new IllegalStateException(string2);
        };
    }

    private static class AllUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllUnderData(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                AllUnderData.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable<ChangesBrowserNode<?>> jBIterable = this.myNode.traverse();
            if (jBIterable == null) {
                AllUnderData.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class SelectedData
    extends ExactlySelectedData {
        SelectedData(@NotNull JTree tree2) {
            if (tree2 == null) {
                SelectedData.$$$reportNull$$$0(0);
            }
            super(tree2);
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = super.iterateRawNodes().flatMap(ChangesBrowserNode::traverse).unique();
            if (jBIterable == null) {
                SelectedData.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ExactlySelectedData
    extends VcsTreeModelData {
        private final TreePath[] myPaths;

        ExactlySelectedData(@NotNull JTree tree2) {
            if (tree2 == null) {
                ExactlySelectedData.$$$reportNull$$$0(0);
            }
            this.myPaths = tree2.getSelectionPaths();
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            Object[] paths = this.myPaths;
            if (paths == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ExactlySelectedData.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.of((Object[])paths).map(path2 -> (ChangesBrowserNode)path2.getLastPathComponent());
            if (jBIterable == null) {
                ExactlySelectedData.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class IncludedUnderData
    extends VcsTreeModelData {
        private final ChangesBrowserNode<?> myNode;
        private final Set<Object> myIncluded;

        IncludedUnderData(@NotNull ChangesTree tree2, @NotNull ChangesBrowserNode<?> node) {
            if (tree2 == null) {
                IncludedUnderData.$$$reportNull$$$0(0);
            }
            if (node == null) {
                IncludedUnderData.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.myIncluded = tree2.getIncludedSet();
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = this.myNode.traverse().filter(node -> this.myIncluded.contains(node.getUserObject()));
            if (jBIterable == null) {
                IncludedUnderData.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class EmptyData
    extends VcsTreeModelData {
        EmptyData() {
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyData.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$EmptyData", "iterateRawNodes"));
        }
    }

    private static class SelectedTagData
    extends ExactlySelectedTagData {
        SelectedTagData(@NotNull JTree tree2, @NotNull Object tag) {
            if (tree2 == null) {
                SelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                SelectedTagData.$$$reportNull$$$0(1);
            }
            super(tree2, tag);
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = super.iterateRawNodes().flatMap(ChangesBrowserNode::traverse).unique();
            if (jBIterable == null) {
                SelectedTagData.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class AllExpandedByDefaultData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllExpandedByDefaultData(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                AllExpandedByDefaultData.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBTreeTraverser traverser = JBTreeTraverser.from(node -> {
                if (node.shouldExpandByDefault()) {
                    return node.iterateNodeChildren();
                }
                return JBIterable.empty();
            });
            JBIterable jBIterable = ((JBTreeTraverser)traverser.withRoot(this.myNode)).preOrderDfsTraversal();
            if (jBIterable == null) {
                AllExpandedByDefaultData.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllExpandedByDefaultData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllExpandedByDefaultData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ExactlySelectedTagData
    extends VcsTreeModelData {
        private final TreePath[] myPaths;
        private final ChangesBrowserNode<?> myTagNode;

        ExactlySelectedTagData(@NotNull JTree tree2, @NotNull Object tag) {
            if (tree2 == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(1);
            }
            this.myPaths = tree2.getSelectionPaths();
            this.myTagNode = ExactlySelectedTagData.findTagNode(tree2, tag);
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            ChangesBrowserNode<?> tagNode = this.myTagNode;
            if (tagNode == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(2);
                }
                return jBIterable;
            }
            Object[] paths = this.myPaths;
            if (paths == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.of((Object[])paths).filter(path2 -> path2.getPathCount() <= 1 || path2.getPathComponent(1) == tagNode).map(path2 -> (ChangesBrowserNode)path2.getLastPathComponent());
            if (jBIterable == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 4 -> new IllegalStateException(string2);
            };
        }
    }
}

