/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MatchResultImpl
extends MatchResult {
    private String name;
    private SmartPsiElementPointer<?> matchRef;
    private int start;
    private int end;
    private String matchImage;
    private final List<MatchResult> myChildren;
    private boolean target;
    private boolean myScopeMatch;
    private boolean myMultipleMatch;
    private MatchResultImpl parent;

    MatchResultImpl() {
        this.end = -1;
        this.myChildren = new SmartList();
    }

    public MatchResultImpl(@NotNull String name, @Nullable String image, @NotNull SmartPsiElementPointer<?> ref, int start2, int end, boolean target) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            MatchResultImpl.$$$reportNull$$$0(1);
        }
        this.end = -1;
        this.myChildren = new SmartList();
        this.matchRef = ref;
        this.name = name;
        this.matchImage = image;
        this.target = target;
        this.start = start2;
        this.end = end;
    }

    public MatchResultImpl(@NotNull String name, @Nullable String image, @NotNull PsiElement match2, int start2, int end, boolean target) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(2);
        }
        if (match2 == null) {
            MatchResultImpl.$$$reportNull$$$0(3);
        }
        this.end = -1;
        this.myChildren = new SmartList();
        this.matchRef = SmartPointerManager.getInstance((Project)match2.getProject()).createSmartPsiElementPointer(match2);
        this.name = name;
        this.matchImage = image;
        this.target = target;
        this.start = start2;
        this.end = end;
    }

    @Override
    public String getMatchImage() {
        return this.matchImage;
    }

    @Override
    public SmartPsiElementPointer<?> getMatchRef() {
        return this.matchRef;
    }

    @Override
    public PsiElement getMatch() {
        if (this.matchRef == null) {
            return null;
        }
        return this.matchRef.getElement();
    }

    public void setMatchRef(@NotNull SmartPsiElementPointer<?> matchStart) {
        if (matchStart == null) {
            MatchResultImpl.$$$reportNull$$$0(4);
        }
        this.matchRef = matchStart;
    }

    public void setMatch(PsiElement element) {
        this.matchRef = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(5);
        }
        this.name = name;
    }

    @Override
    @NotNull
    public List<MatchResult> getChildren() {
        List<MatchResult> list = Collections.unmodifiableList(this.myChildren);
        if (list == null) {
            MatchResultImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public int size() {
        if (!this.myMultipleMatch) {
            return this.getMatch() != null ? 1 : 0;
        }
        return this.myChildren.size();
    }

    @Override
    public boolean isScopeMatch() {
        return this.myScopeMatch;
    }

    @Override
    public boolean isMultipleMatch() {
        return this.myMultipleMatch;
    }

    @Override
    public boolean hasChildren() {
        return !this.myChildren.isEmpty();
    }

    public void removeChildren() {
        this.myChildren.clear();
    }

    @NotNull
    public MatchResult removeLastChild() {
        MatchResult matchResult = this.myChildren.remove(this.myChildren.size() - 1);
        if (matchResult == null) {
            MatchResultImpl.$$$reportNull$$$0(7);
        }
        return matchResult;
    }

    public void setScopeMatch(boolean scopeMatch) {
        this.myScopeMatch = scopeMatch;
    }

    public void setMultipleMatch(boolean multipleMatch) {
        this.myMultipleMatch = multipleMatch;
    }

    public MatchResultImpl getChild(@NotNull String name) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(8);
        }
        for (MatchResult match2 : this.myChildren) {
            MatchResultImpl res = (MatchResultImpl)match2;
            if (!name.equals(res.getName())) continue;
            return res;
        }
        return null;
    }

    public MatchResult findChild(@NotNull String name) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(9);
        }
        for (MatchResult child : this.myChildren) {
            if (name.equals(child.getName())) {
                return child;
            }
            MatchResult deep = ((MatchResultImpl)child).findChild(name);
            if (deep == null) continue;
            return deep;
        }
        return null;
    }

    public MatchResult removeChild(@NotNull String typedVar) {
        if (typedVar == null) {
            MatchResultImpl.$$$reportNull$$$0(10);
        }
        int size = this.myChildren.size();
        for (int i = 0; i < size; ++i) {
            MatchResult child = this.myChildren.get(i);
            if (!typedVar.equals(child.getName())) continue;
            this.myChildren.remove(i);
            return child;
        }
        return null;
    }

    public void addChild(@NotNull MatchResult result2) {
        if (result2 == null) {
            MatchResultImpl.$$$reportNull$$$0(11);
        }
        if (result2 instanceof MatchResultImpl) {
            ((MatchResultImpl)result2).parent = this;
        }
        this.myChildren.add(result2);
    }

    @Override
    @NotNull
    public MatchResult getRoot() {
        if (this.parent == null) {
            MatchResultImpl matchResultImpl = this;
            if (matchResultImpl == null) {
                MatchResultImpl.$$$reportNull$$$0(12);
            }
            return matchResultImpl;
        }
        MatchResultImpl root = this.parent;
        while (root.parent != null) {
            root = root.parent;
        }
        MatchResultImpl matchResultImpl = root;
        if (matchResultImpl == null) {
            MatchResultImpl.$$$reportNull$$$0(13);
        }
        return matchResultImpl;
    }

    public void setMatchImage(@NotNull String matchImage) {
        if (matchImage == null) {
            MatchResultImpl.$$$reportNull$$$0(14);
        }
        this.matchImage = matchImage;
    }

    @Override
    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start2) {
        this.start = start2;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        return "MatchResultImpl{name='" + this.name + "', matchImage='" + this.matchImage + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStart";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/MatchResultImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedVar";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/MatchResultImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastChild";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMatchRef";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setMatchImage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 12, 13 -> new IllegalStateException(string2);
        };
    }
}

