/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.ElementPresentationTemplateImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildDescriptionImpl
implements AbstractDomChildrenDescription,
Comparable<AbstractDomChildDescriptionImpl> {
    private final Type myType;
    private Map<Class<? extends Annotation>, Annotation> myCustomAnnotations;
    @Nullable
    private Map<Key<?>, Object> myUserMap;
    private volatile Ref<ElementPresentationTemplate> myPresentationTemplate = null;
    private volatile Boolean myStubbed;

    @Nullable
    private ElementPresentationTemplate calcPresentationTemplate() {
        Class clazz = ClassUtil.getRawType((Type)this.getType());
        Presentation presentation2 = DomApplicationComponent.getInstance().getInvocationCache(clazz).getClassAnnotation(Presentation.class);
        return presentation2 == null ? null : new ElementPresentationTemplateImpl(presentation2, clazz);
    }

    protected AbstractDomChildDescriptionImpl(Type type2) {
        this.myType = type2;
    }

    public final void addCustomAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(0);
        }
        if (this.myCustomAnnotations == null) {
            this.myCustomAnnotations = new HashMap<Class<? extends Annotation>, Annotation>();
        }
        this.myCustomAnnotations.put(annotation.annotationType(), annotation);
    }

    private boolean calcStubbed() {
        return this.myType instanceof Class && DomReflectionUtil.findAnnotationDFS((Class)this.myType, Stubbed.class) != null || this.getAnnotation(Stubbed.class) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomChildDescriptionImpl that = (AbstractDomChildDescriptionImpl)o;
        return Objects.equals(this.myCustomAnnotations, that.myCustomAnnotations) && this.getType().equals(that.getType()) && Objects.equals(this.myUserMap, that.myUserMap);
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + (this.myCustomAnnotations != null ? this.myCustomAnnotations.hashCode() : 0);
        result2 = 31 * result2 + (this.myUserMap != null ? this.myUserMap.hashCode() : 0);
        return result2;
    }

    public void setUserMap(@Nullable Map<Key<?>, Object> userMap) {
        this.myUserMap = userMap;
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)(this.myCustomAnnotations == null ? null : (Annotation)annotationClass.cast(this.myCustomAnnotations.get(annotationClass)));
    }

    @Override
    public <T> T getUserData(Key<T> key2) {
        return (T)(this.myUserMap == null ? null : this.myUserMap.get(key2));
    }

    @Override
    @NotNull
    public final List<? extends DomElement> getStableValues(@NotNull DomElement parent) {
        if (parent == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(1);
        }
        List<? extends DomElement> list = this.getValues(parent);
        ArrayList result2 = new ArrayList(list.size());
        DomManager domManager = parent.getManager();
        int i = 0;
        while (i < list.size()) {
            int i1 = i++;
            result2.add(domManager.createStableValue(() -> {
                if (!parent.isValid()) {
                    return null;
                }
                List<? extends DomElement> domElements = this.getValues(parent);
                return domElements.size() > i1 ? domElements.get(i1) : null;
            }));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public final Type getType() {
        Type type2 = this.myType;
        if (type2 == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(3);
        }
        return type2;
    }

    @Override
    @NotNull
    public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
        DomNameStrategy strategy;
        if (parent == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(4);
        }
        DomNameStrategy domNameStrategy = (strategy = DomImplUtil.getDomNameStrategy(ClassUtil.getRawType((Type)this.getType()), false)) == null ? parent.getNameStrategy() : strategy;
        if (domNameStrategy == null) {
            AbstractDomChildDescriptionImpl.$$$reportNull$$$0(5);
        }
        return domNameStrategy;
    }

    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public ElementPresentationTemplate getPresentationTemplate() {
        Ref ref = this.myPresentationTemplate;
        if (ref == null) {
            this.myPresentationTemplate = ref = Ref.create((Object)this.calcPresentationTemplate());
        }
        return (ElementPresentationTemplate)ref.get();
    }

    @Override
    @Nullable
    public PsiElement getDeclaration(Project project2) {
        DomElement domDeclaration = this.getDomDeclaration();
        if (domDeclaration != null) {
            DomTarget target = DomTarget.getTarget(domDeclaration);
            if (target != null) {
                return PomService.convertToPsi((PsiTarget)target);
            }
            return domDeclaration.getXmlElement();
        }
        SmartPsiElementPointer<?> pointer = this.getUserData(DomExtensionImpl.DECLARING_ELEMENT_KEY);
        if (pointer != null) {
            return pointer.getElement();
        }
        return PomService.convertToPsi((Project)project2, (PomTarget)this);
    }

    @Override
    public DomElement getDomDeclaration() {
        Supplier<? extends DomElement> domDecl = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        return domDecl != null ? domDecl.get() : null;
    }

    @Override
    public boolean isStubbed() {
        Boolean stubbed = this.myStubbed;
        if (stubbed == null) {
            this.myStubbed = stubbed = Boolean.valueOf(this.calcStubbed());
        }
        return stubbed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStableValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomNameStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCustomAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStableValues";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDomNameStrategy";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 5 -> new IllegalStateException(string2);
        };
    }
}

