/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomFileIndex;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomServiceImpl
extends DomService {
    @NotNull
    private static XmlFileHeader calcXmlFileHeader(@NotNull XmlFile file) {
        Stub root;
        ObjectStubTree tree2;
        VirtualFile virtualFile;
        if (file == null) {
            DomServiceImpl.$$$reportNull$$$0(0);
        }
        if (file instanceof PsiFileEx && ((PsiFileEx)file).isContentsLoaded() && file.getNode().isParsed()) {
            XmlFileHeader xmlFileHeader = DomServiceImpl.computeHeaderByPsi(file);
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(1);
            }
            return xmlFileHeader;
        }
        if (FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() == null && XmlUtil.BUILDING_DOM_STUBS.get() != Boolean.TRUE && file.getFileType() == XmlFileType.INSTANCE && (virtualFile = file.getVirtualFile()) instanceof VirtualFileWithId && (tree2 = StubTreeLoader.getInstance().readFromVFile(file.getProject(), virtualFile)) != null && (root = tree2.getRoot()) instanceof FileStub) {
            XmlFileHeader xmlFileHeader = ((FileStub)root).getHeader();
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(2);
            }
            return xmlFileHeader;
        }
        if (!file.isValid()) {
            XmlFileHeader xmlFileHeader = XmlFileHeader.EMPTY;
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(3);
            }
            return xmlFileHeader;
        }
        XmlFileHeader header = NanoXmlUtil.parseHeader((PsiFile)file);
        if (header.getRootTagLocalName() == null) {
            XmlFileHeader xmlFileHeader = DomServiceImpl.computeHeaderByPsi(file);
            if (xmlFileHeader == null) {
                DomServiceImpl.$$$reportNull$$$0(4);
            }
            return xmlFileHeader;
        }
        XmlFileHeader xmlFileHeader = header;
        if (xmlFileHeader == null) {
            DomServiceImpl.$$$reportNull$$$0(5);
        }
        return xmlFileHeader;
    }

    private static XmlFileHeader computeHeaderByPsi(XmlFile file) {
        XmlTag tag;
        XmlDoctype doctype;
        XmlDocument document2 = file.getDocument();
        if (document2 == null) {
            return XmlFileHeader.EMPTY;
        }
        String publicId = null;
        String systemId = null;
        XmlProlog prolog = document2.getProlog();
        if (prolog != null && (doctype = prolog.getDoctype()) != null) {
            publicId = doctype.getPublicId();
            systemId = doctype.getSystemId();
            if (systemId == null) {
                systemId = doctype.getDtdUri();
            }
        }
        if ((tag = document2.getRootTag()) == null) {
            return XmlFileHeader.EMPTY;
        }
        String localName = tag.getLocalName();
        if (StringUtil.isNotEmpty((String)localName)) {
            if (tag.getPrevSibling() instanceof PsiErrorElement) {
                return XmlFileHeader.EMPTY;
            }
            String psiNs = tag.getLocalNamespaceDeclarations().get(tag.getNamespacePrefix());
            return new XmlFileHeader(localName, psiNs, publicId, systemId);
        }
        return XmlFileHeader.EMPTY;
    }

    @Override
    @NotNull
    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    @Override
    public <T extends DomElement> DomAnchor<T> createAnchor(T domElement) {
        return DomAnchorImpl.createAnchor(domElement);
    }

    @Override
    @NotNull
    public XmlFile getContainingFile(@NotNull DomElement domElement) {
        if (domElement == null) {
            DomServiceImpl.$$$reportNull$$$0(6);
        }
        if (domElement instanceof DomFileElement) {
            XmlFile xmlFile = ((DomFileElement)domElement).getFile();
            if (xmlFile == null) {
                DomServiceImpl.$$$reportNull$$$0(7);
            }
            return xmlFile;
        }
        XmlFile xmlFile = DomManagerImpl.getNotNullHandler(domElement).getFile();
        if (xmlFile == null) {
            DomServiceImpl.$$$reportNull$$$0(8);
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public EvaluatedXmlName getEvaluatedXmlName(@NotNull DomElement element) {
        if (element == null) {
            DomServiceImpl.$$$reportNull$$$0(9);
        }
        EvaluatedXmlName evaluatedXmlName = DomManagerImpl.getNotNullHandler(element).getXmlName();
        if (evaluatedXmlName == null) {
            DomServiceImpl.$$$reportNull$$$0(10);
        }
        return evaluatedXmlName;
    }

    @Override
    @NotNull
    public XmlFileHeader getXmlFileHeader(@NotNull XmlFile file) {
        if (file == null) {
            DomServiceImpl.$$$reportNull$$$0(11);
        }
        if (FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null) {
            return DomServiceImpl.calcXmlFileHeader(file);
        }
        XmlFileHeader xmlFileHeader = (XmlFileHeader)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)DomServiceImpl.calcXmlFileHeader(file), new Object[]{file}));
        if (xmlFileHeader == null) {
            DomServiceImpl.$$$reportNull$$$0(12);
        }
        return xmlFileHeader;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDomFileCandidates(@NotNull Class<? extends DomElement> rootElementClass, @NotNull GlobalSearchScope scope2) {
        DomFileDescription<?> description2;
        if (rootElementClass == null) {
            DomServiceImpl.$$$reportNull$$$0(13);
        }
        if (scope2 == null) {
            DomServiceImpl.$$$reportNull$$$0(14);
        }
        if ((description2 = DomApplicationComponent.getInstance().findFileDescription(rootElementClass)) == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                DomServiceImpl.$$$reportNull$$$0(15);
            }
            return set;
        }
        String[] namespaces = description2.getAllPossibleRootTagNamespaces();
        if (namespaces.length == 0) {
            namespaces = new String[]{null};
        }
        String rootTagName = description2.getRootTagName();
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (String namespace : namespaces) {
            files2.addAll(DomFileIndex.findFiles(rootTagName, namespace, scope2));
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            DomServiceImpl.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public <T extends DomElement> List<DomFileElement<T>> getFileElements(@NotNull Class<T> clazz, @NotNull Project project2, @Nullable GlobalSearchScope scope2) {
        Collection<VirtualFile> list;
        if (clazz == null) {
            DomServiceImpl.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            DomServiceImpl.$$$reportNull$$$0(18);
        }
        if ((list = this.getDomFileCandidates(clazz, scope2 != null ? scope2 : GlobalSearchScope.allScope((Project)project2))).isEmpty()) {
            List<DomFileElement<T>> list2 = Collections.emptyList();
            if (list2 == null) {
                DomServiceImpl.$$$reportNull$$$0(19);
            }
            return list2;
        }
        ArrayList<DomFileElement<T>> result2 = new ArrayList<DomFileElement<T>>(list.size());
        for (VirtualFile file : list) {
            DomFileElement<T> element;
            PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file);
            if (!(psiFile2 instanceof XmlFile) || (element = DomManager.getDomManager(project2).getFileElement((XmlFile)psiFile2, clazz)) == null) continue;
            result2.add(element);
        }
        ArrayList<DomFileElement<T>> arrayList = result2;
        if (arrayList == null) {
            DomServiceImpl.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public StructureViewBuilder createSimpleStructureViewBuilder(@NotNull XmlFile file, @NotNull Function<DomElement, DomService.StructureViewMode> modeProvider) {
        if (file == null) {
            DomServiceImpl.$$$reportNull$$$0(21);
        }
        if (modeProvider == null) {
            DomServiceImpl.$$$reportNull$$$0(22);
        }
        return new DomStructureViewBuilder(file, modeProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 8, 10, 12, 15, 16, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomServiceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElementClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomServiceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcXmlFileHeader";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluatedXmlName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFileHeader";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomFileCandidates";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcXmlFileHeader";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluatedXmlName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getXmlFileHeader";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDomFileCandidates";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileElements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleStructureViewBuilder";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 4, 5, 7, 8, 10, 12, 15, 16, 19, 20 -> new IllegalStateException(string2);
        };
    }
}

