/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.ide;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonSchemaService {
    public static boolean isSchemaFile(@NotNull PsiFile psiFile2) {
        if (psiFile2 == null) {
            JsonSchemaService.$$$reportNull$$$0(0);
        }
        if (JsonLikePsiWalker.getWalker((PsiElement)psiFile2, JsonSchemaObject.NULL_OBJ) == null) {
            return false;
        }
        VirtualFile file = psiFile2.getViewProvider().getVirtualFile();
        JsonSchemaService service = Impl.get(psiFile2.getProject());
        return service.isSchemaFile(file) && service.isApplicableToFile(file);
    }

    public boolean isSchemaFile(@NotNull VirtualFile var1);

    public boolean isSchemaFile(@NotNull JsonSchemaObject var1);

    @NotNull
    public Project getProject();

    @Nullable
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile var1);

    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile var1);

    public void registerRemoteUpdateCallback(@NotNull Runnable var1);

    public void unregisterRemoteUpdateCallback(@NotNull Runnable var1);

    public void registerResetAction(Runnable var1);

    public void unregisterResetAction(Runnable var1);

    public void registerReference(String var1);

    public boolean possiblyHasReference(String var1);

    public void triggerUpdateRemote();

    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile var1);

    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull PsiFile var1);

    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String var1, @Nullable VirtualFile var2);

    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile var1);

    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject var1);

    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject var1);

    public void reset();

    public List<JsonSchemaInfo> getAllUserVisibleSchemas();

    public boolean isApplicableToFile(@Nullable VirtualFile var1);

    @NotNull
    public JsonSchemaCatalogManager getCatalogManager();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/jsonSchema/ide/JsonSchemaService", "isSchemaFile"));
    }

    public static final class Impl {
        public static JsonSchemaService get(@NotNull Project project2) {
            if (project2 == null) {
                Impl.$$$reportNull$$$0(0);
            }
            return (JsonSchemaService)project2.getService(JsonSchemaService.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/ide/JsonSchemaService$Impl", "get"));
        }
    }
}

